/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.VampirismPotion;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModPotions {
    public static final DeferredRegister<Potion> POTION_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTION_TYPES, (String)"vampirism");
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_SLOW_FALLING = POTION_TYPES.register("very_long_slow_falling", () -> new VampirismPotion.HunterPotion("slow_falling", new EffectInstance(Effects.field_204839_B, 48000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_LUCK = POTION_TYPES.register("long_luck", () -> new VampirismPotion.HunterPotion("luck", new EffectInstance(Effects.field_188425_z, 60000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_WEAKNESS = POTION_TYPES.register("very_long_weakness", () -> new VampirismPotion.HunterPotion("weakness", new EffectInstance(Effects.field_76437_t, 48000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_STRENGTH = POTION_TYPES.register("very_strong_strength", () -> new VampirismPotion.HunterPotion("strength", new EffectInstance(Effects.field_76420_g, 600, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_STRENGTH = POTION_TYPES.register("very_long_strength", () -> new VampirismPotion.HunterPotion("strength", new EffectInstance(Effects.field_76420_g, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_STRENGTH = POTION_TYPES.register("long_strong_strength", () -> new VampirismPotion.HunterPotion("strength", new EffectInstance(Effects.field_76420_g, 4800, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_REGENERATION = POTION_TYPES.register("very_strong_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new EffectInstance(Effects.field_76428_l, 450, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_REGENERATION = POTION_TYPES.register("very_long_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new EffectInstance(Effects.field_76428_l, 18000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_REGENERATION = POTION_TYPES.register("long_strong_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new EffectInstance(Effects.field_76428_l, 1200, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_POISON = POTION_TYPES.register("very_strong_poison", () -> new VampirismPotion.HunterPotion("poison", new EffectInstance(Effects.field_76436_u, 432, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_POISON = POTION_TYPES.register("long_strong_poison", () -> new VampirismPotion.HunterPotion("poison", new EffectInstance(Effects.field_76436_u, 1200, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_POISON = POTION_TYPES.register("very_long_poison", () -> new VampirismPotion.HunterPotion("poison", new EffectInstance(Effects.field_76436_u, 18000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_HEALING = POTION_TYPES.register("very_strong_healing", () -> new VampirismPotion.HunterPotion("healing", new EffectInstance(Effects.field_76432_h, 1, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_WATER_BREATHING = POTION_TYPES.register("very_long_water_breathing", () -> new VampirismPotion.HunterPotion("water_breathing", new EffectInstance(Effects.field_76427_o, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_SLOWNESS = POTION_TYPES.register("very_strong_slowness", () -> new VampirismPotion.HunterPotion("slowness", new EffectInstance(Effects.field_76421_d, 400, 5)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_SLOWNESS = POTION_TYPES.register("very_long_slowness", () -> new VampirismPotion.HunterPotion("slowness", new EffectInstance(Effects.field_76421_d, 48000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_SLOWNESS = POTION_TYPES.register("long_strong_slowness", () -> new VampirismPotion.HunterPotion("slowness", new EffectInstance(Effects.field_76421_d, 4800, 3)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_SWIFTNESS = POTION_TYPES.register("very_strong_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new EffectInstance(Effects.field_76424_c, 1200, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_SWIFTNESS = POTION_TYPES.register("very_long_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new EffectInstance(Effects.field_76424_c, 48000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_SWIFTNESS = POTION_TYPES.register("long_strong_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new EffectInstance(Effects.field_76424_c, 4800, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_FIRE_RESISTANCE = POTION_TYPES.register("very_long_fire_resistance", () -> new VampirismPotion.HunterPotion("fire_resistance", new EffectInstance(Effects.field_76426_n, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_LEAPING = POTION_TYPES.register("very_strong_leaping", () -> new VampirismPotion.HunterPotion("leaping", new EffectInstance(Effects.field_76430_j, 1800, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_LEAPING = POTION_TYPES.register("very_long_leaping", () -> new VampirismPotion.HunterPotion("leaping", new EffectInstance(Effects.field_76430_j, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_LEAPING = POTION_TYPES.register("long_strong_leaping", () -> new VampirismPotion.HunterPotion("leaping", new EffectInstance(Effects.field_76430_j, 9600, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_INVISIBILITY = POTION_TYPES.register("very_long_invisibility", () -> new VampirismPotion.HunterPotion("invisibility", new EffectInstance(Effects.field_76441_p, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_NIGHT_VISION = POTION_TYPES.register("very_long_night_vision", () -> new VampirismPotion.HunterPotion("night_vision", new EffectInstance(Effects.field_76439_r, 96000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> NAUSEA = POTION_TYPES.register("nausea", () -> new VampirismPotion.HunterPotion(null, new EffectInstance(Effects.field_76431_k, 1200)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_NAUSEA = POTION_TYPES.register("long_nausea", () -> new VampirismPotion.HunterPotion("nausea", new EffectInstance(Effects.field_76431_k, 2400)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_NAUSEA = POTION_TYPES.register("very_long_nausea", () -> new VampirismPotion.HunterPotion("nausea", new EffectInstance(Effects.field_76431_k, 24000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> BLINDNESS = POTION_TYPES.register("blindness", () -> new VampirismPotion.HunterPotion(null, new EffectInstance(Effects.field_76440_q, 1200)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_BLINDNESS = POTION_TYPES.register("long_blindness", () -> new VampirismPotion.HunterPotion("blindness", new EffectInstance(Effects.field_76440_q, 4800)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_BLINDNESS = POTION_TYPES.register("very_long_blindness", () -> new VampirismPotion.HunterPotion("blindness", new EffectInstance(Effects.field_76440_q, 24000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> HEALTH_BOOST = POTION_TYPES.register("health_boost", () -> new VampirismPotion.HunterPotion(null, new EffectInstance(Effects.field_180152_w, 1200)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_HEALTH_BOOST = POTION_TYPES.register("long_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new EffectInstance(Effects.field_180152_w, 4800)));
    public static final RegistryObject<VampirismPotion.HunterPotion> STRONG_HEALTH_BOOST = POTION_TYPES.register("strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new EffectInstance(Effects.field_180152_w, 400, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_HEALTH_BOOST = POTION_TYPES.register("very_long_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new EffectInstance(Effects.field_180152_w, 48000)));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_STRONG_HEALTH_BOOST = POTION_TYPES.register("very_strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new EffectInstance(Effects.field_180152_w, 400, 2)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_HEALTH_BOOST = POTION_TYPES.register("long_strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new EffectInstance(Effects.field_180152_w, 1200, 1)));
    public static final RegistryObject<VampirismPotion.HunterPotion> RESISTANCE = POTION_TYPES.register("resistance", () -> new VampirismPotion.HunterPotion(null, new EffectInstance(Effects.field_76429_m, 1800)));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_RESISTANCE = POTION_TYPES.register("long_resistance", () -> new VampirismPotion.HunterPotion("resistance", new EffectInstance(Effects.field_76429_m, 4800)));
    public static final RegistryObject<VampirismPotion.HunterPotion> STRONG_RESISTANCE = POTION_TYPES.register("strong_resistance", () -> new VampirismPotion.HunterPotion("resistance", new EffectInstance(Effects.field_76429_m, 400, 1)));
    public static final RegistryObject<VampirismPotion> VAMPIRE_FIRE_RESISTANCE = POTION_TYPES.register("vampire_fire_resistance", () -> new VampirismPotion(null, new EffectInstance((Effect)ModEffects.FIRE_PROTECTION.get(), 3600, 5)));
    public static final RegistryObject<VampirismPotion> LONG_VAMPIRE_FIRE_RESISTANCE = POTION_TYPES.register("long_vampire_fire_resistance", () -> new VampirismPotion("vampire_fire_resistance", new EffectInstance((Effect)ModEffects.FIRE_PROTECTION.get(), 9600, 5)));

    public static void registerPotions(IEventBus bus) {
        POTION_TYPES.register(bus);
    }

    public static void registerPotionMixes() {
        IExtendedBrewingRecipeRegistry registry = VampirismAPI.extendedBrewingRecipeRegistry();
        ModPotions.veryDurable(Potions.field_222126_O, (Potion)LONG_LUCK.get());
        ModPotions.veryDurable(Potions.field_204842_P, (Potion)VERY_LONG_SLOW_FALLING.get());
        ModPotions.veryDurable(Potions.field_185227_J, (Potion)VERY_LONG_WEAKNESS.get());
        ModPotions.veryStrong(Potions.field_185225_H, (Potion)VERY_STRONG_STRENGTH.get());
        ModPotions.veryDurable(Potions.field_185224_G, (Potion)VERY_LONG_STRENGTH.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_STRENGTH.get(), (Potion)LONG_STRONG_STRENGTH.get());
        ModPotions.veryStrong((Potion)VERY_LONG_STRENGTH.get(), (Potion)LONG_STRONG_STRENGTH.get());
        ModPotions.veryDurable(Potions.field_185221_D, (Potion)VERY_LONG_REGENERATION.get());
        ModPotions.veryStrong(Potions.field_185222_E, (Potion)VERY_STRONG_REGENERATION.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_REGENERATION.get(), (Potion)LONG_STRONG_REGENERATION.get());
        ModPotions.veryStrong((Potion)VERY_LONG_REGENERATION.get(), (Potion)LONG_STRONG_REGENERATION.get());
        ModPotions.veryDurable(Potions.field_185218_A, (Potion)VERY_LONG_POISON.get());
        ModPotions.veryStrong(Potions.field_185219_B, (Potion)VERY_STRONG_POISON.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_POISON.get(), (Potion)LONG_STRONG_POISON.get());
        ModPotions.veryStrong((Potion)VERY_LONG_POISON.get(), (Potion)LONG_STRONG_POISON.get());
        ModPotions.veryStrong(Potions.field_185251_w, (Potion)VERY_STRONG_HEALING.get());
        ModPotions.veryDurable(Potions.field_185249_u, (Potion)VERY_LONG_WATER_BREATHING.get());
        ModPotions.veryDurable(Potions.field_185247_s, (Potion)VERY_LONG_SLOWNESS.get());
        ModPotions.veryStrong(Potions.field_203185_t, (Potion)VERY_STRONG_SLOWNESS.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_SLOWNESS.get(), (Potion)LONG_STRONG_SLOWNESS.get());
        ModPotions.veryStrong((Potion)VERY_LONG_SLOWNESS.get(), (Potion)LONG_STRONG_SLOWNESS.get());
        ModPotions.veryDurable(Potions.field_185244_p, (Potion)VERY_LONG_SWIFTNESS.get());
        ModPotions.veryStrong(Potions.field_185245_q, (Potion)VERY_STRONG_SWIFTNESS.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_SWIFTNESS.get(), (Potion)LONG_STRONG_SWIFTNESS.get());
        ModPotions.veryStrong((Potion)VERY_LONG_SWIFTNESS.get(), (Potion)LONG_STRONG_SWIFTNESS.get());
        ModPotions.veryDurable(Potions.field_185242_n, (Potion)VERY_LONG_FIRE_RESISTANCE.get());
        ModPotions.veryStrong(Potions.field_185240_l, (Potion)VERY_STRONG_LEAPING.get());
        ModPotions.veryDurable(Potions.field_185239_k, (Potion)VERY_LONG_LEAPING.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_LEAPING.get(), (Potion)LONG_STRONG_LEAPING.get());
        ModPotions.veryStrong((Potion)VERY_LONG_LEAPING.get(), (Potion)LONG_STRONG_LEAPING.get());
        ModPotions.veryDurable(Potions.field_185237_i, (Potion)VERY_LONG_INVISIBILITY.get());
        ModPotions.veryDurable(Potions.field_185235_g, (Potion)VERY_LONG_NIGHT_VISION.get());
        ModPotions.master((Potion)NAUSEA.get(), (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199805_a((ITag)Tags.Items.MUSHROOMS)), 32, 16);
        ModPotions.durable((Potion)NAUSEA.get(), (Potion)LONG_NAUSEA.get());
        ModPotions.veryDurable((Potion)LONG_NAUSEA.get(), (Potion)VERY_LONG_NAUSEA.get());
        ModPotions.master((Potion)BLINDNESS.get(), (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196136_br})), 64, 32);
        ModPotions.durable((Potion)BLINDNESS.get(), (Potion)LONG_BLINDNESS.get());
        ModPotions.veryDurable((Potion)LONG_BLINDNESS.get(), (Potion)VERY_LONG_BLINDNESS.get());
        ModPotions.master((Potion)HEALTH_BOOST.get(), (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e})), 64, 32);
        ModPotions.durable((Potion)HEALTH_BOOST.get(), (Potion)LONG_HEALTH_BOOST.get());
        ModPotions.strong((Potion)HEALTH_BOOST.get(), (Potion)STRONG_HEALTH_BOOST.get());
        ModPotions.veryDurable((Potion)LONG_HEALTH_BOOST.get(), (Potion)VERY_LONG_HEALTH_BOOST.get());
        ModPotions.veryStrong((Potion)STRONG_HEALTH_BOOST.get(), (Potion)VERY_STRONG_HEALTH_BOOST.get());
        ModPotions.veryDurable((Potion)VERY_STRONG_HEALTH_BOOST.get(), (Potion)LONG_STRONG_HEALTH_BOOST.get());
        ModPotions.veryStrong((Potion)VERY_LONG_HEALTH_BOOST.get(), (Potion)LONG_STRONG_HEALTH_BOOST.get());
        ModPotions.master((Potion)RESISTANCE.get(), (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao})), 20, 10);
        ModPotions.durable((Potion)RESISTANCE.get(), (Potion)LONG_RESISTANCE.get());
        ModPotions.strong((Potion)RESISTANCE.get(), (Potion)STRONG_RESISTANCE.get());
    }

    private static void durable(Potion in, Potion out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient((NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax})), 1).blood().build());
    }

    private static void strong(Potion in, Potion out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient((NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO})), 1).blood().build());
    }

    private static void veryDurable(Potion in, Potion out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient((NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em})), 32, 16).blood().durable().build());
    }

    private static void veryStrong(Potion in, Potion out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient((NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221695_cJ})), 64, 32).blood().concentrated().build());
    }

    private static void master(Potion out, NonNullSupplier<Ingredient> in, int count, int countReduced) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(Potions.field_185233_e, out).master().ingredient(in, count, countReduced).blood().build());
    }

    public static void fixMappings(RegistryEvent.MissingMappings<Potion> event) {
        event.getAllMappings().forEach(missingMapping -> {
            switch (missingMapping.key.toString()) {
                case "vampirism:long_strong_resistance": 
                case "vampirism:very_long_resistance": {
                    missingMapping.remap(LONG_RESISTANCE.get());
                    break;
                }
                case "vampirism:very_strong_resistance": {
                    missingMapping.remap(STRONG_RESISTANCE.get());
                    break;
                }
                case "vampirism:thirst": 
                case "vampirism:long_thirst": 
                case "vampirism:strong_thirst": 
                case "vampirism:very_long_thirst": 
                case "vampirism:very_strong_thirst": 
                case "vampirism:long_strong_thirst": {
                    missingMapping.ignore();
                    break;
                }
                case "vampirism:very_strong_harming": {
                    missingMapping.remap((IForgeRegistryEntry)Potions.field_185253_y);
                }
            }
        });
    }
}

