/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.recipes.AlchemyTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ApplicableOilRecipe;
import de.teamlapen.vampirism.inventory.recipes.CleanOilRecipe;
import de.teamlapen.vampirism.inventory.recipes.ConfigCondition;
import de.teamlapen.vampirism.inventory.recipes.ShapedItemWithTierRepair;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.util.NBTIngredient;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRecipes {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"vampirism");
    public static final IRecipeType<IWeaponTableRecipe> WEAPONTABLE_CRAFTING_TYPE = IRecipeType.func_222147_a((String)new ResourceLocation("vampirism", "weapontable_crafting").toString());
    public static final IRecipeType<AlchemicalCauldronRecipe> ALCHEMICAL_CAULDRON_TYPE = IRecipeType.func_222147_a((String)new ResourceLocation("vampirism", "alchemical_cauldron").toString());
    public static final IRecipeType<AlchemyTableRecipe> ALCHEMICAL_TABLE_TYPE = IRecipeType.func_222147_a((String)new ResourceLocation("vampirism", "alchemical_table").toString());
    public static final RegistryObject<IRecipeSerializer<ShapedWeaponTableRecipe>> SHAPED_CRAFTING_WEAPONTABLE = ModRecipes.register("shaped_crafting_weapontable", ShapedWeaponTableRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<ShapelessWeaponTableRecipe>> SHAPELESS_CRAFTING_WEAPONTABLE = ModRecipes.register("shapeless_crafting_weapontable", ShapelessWeaponTableRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<ShapedRecipe>> REPAIR_IITEMWITHTIER = ModRecipes.register("repair_iitemwithtier", ShapedItemWithTierRepair.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<AlchemicalCauldronRecipe>> ALCHEMICAL_CAULDRON = ModRecipes.register("alchemical_cauldron", AlchemicalCauldronRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<AlchemyTableRecipe>> ALCHEMICAL_TABLE = ModRecipes.register("alchemical_table", AlchemyTableRecipe.Serializer::new);
    public static final RegistryObject<SpecialRecipeSerializer<ApplicableOilRecipe>> APPLICABLE_OIL = ModRecipes.register("applicable_oil", () -> new SpecialRecipeSerializer(ApplicableOilRecipe::new));
    public static final RegistryObject<SpecialRecipeSerializer<CleanOilRecipe>> CLEAN_OIL = ModRecipes.register("clean_oil", () -> new SpecialRecipeSerializer(CleanOilRecipe::new));
    public static final IConditionSerializer<?> CONFIG_CONDITION = CraftingHelper.register((IConditionSerializer)new ConfigCondition.Serializer());
    private static final Map<Item, Integer> liquidColors = Maps.newHashMap();
    private static final Map<ITag<Item>, Integer> liquidColorsTags = Maps.newHashMap();

    static void registerDefaultLiquidColors() {
        ModRecipes.registerLiquidColor((Item)ModItems.HOLY_WATER_BOTTLE_NORMAL.get(), 0x6666FF);
        ModRecipes.registerLiquidColor((Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), 0x6666FF);
        ModRecipes.registerLiquidColor((Item)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get(), 0x6666FF);
        ModRecipes.registerLiquidColor(ModTags.Items.GARLIC, 0xBBBBBB);
    }

    static void registerRecipeTypesAndSerializers(IEventBus bus) {
        RECIPE_SERIALIZERS.register(bus);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("vampirism", "item"), (IIngredientSerializer)NBTIngredient.Serializer.INSTANCE);
    }

    private static <Z extends IRecipeSerializer<T>, T extends IRecipe<?>> RegistryObject<Z> register(String name, Supplier<Z> sup) {
        return RECIPE_SERIALIZERS.register(name, sup);
    }

    public static void registerLiquidColor(Item item, int color) {
        liquidColors.put(item, color);
    }

    public static void registerLiquidColor(ITag<Item> items, int color) {
        liquidColorsTags.put(items, color);
    }

    public static int getLiquidColor(Item stack) {
        Integer c = liquidColors.get(stack);
        if (c != null) {
            return c;
        }
        for (Map.Entry<ITag<Item>, Integer> entry : liquidColorsTags.entrySet()) {
            if (!entry.getKey().func_230235_a_((Object)stack)) continue;
            return entry.getValue();
        }
        return 0x505050;
    }
}

