/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.FactionVillagerProfession;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.entity.villager.VampireVillagerHostilesSensor;
import de.teamlapen.vampirism.world.FactionPointOfInterestType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.schedule.ScheduleBuilder;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModVillage {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"vampirism");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"vampirism");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)"vampirism");
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SCHEDULES, (String)"vampirism");
    public static final RegistryObject<FactionPointOfInterestType> HUNTER_FACTION = POI_TYPES.register("hunter_faction", () -> (FactionPointOfInterestType)PointOfInterestType.func_221052_a((PointOfInterestType)new FactionPointOfInterestType("hunter_faction", ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get(), (Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED.get()), 1, 1)));
    public static final RegistryObject<FactionPointOfInterestType> VAMPIRE_FACTION = POI_TYPES.register("vampire_faction", () -> (FactionPointOfInterestType)PointOfInterestType.func_221052_a((PointOfInterestType)new FactionPointOfInterestType("vampire_faction", ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), (Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get()), 1, 1)));
    public static final RegistryObject<FactionPointOfInterestType> NO_FACTION = POI_TYPES.register("no_faction", () -> (FactionPointOfInterestType)PointOfInterestType.func_221052_a((PointOfInterestType)new FactionPointOfInterestType("no_faction", ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP.get(), (Block)ModBlocks.TOTEM_TOP_CRAFTED.get()), 1, 1)));
    public static final RegistryObject<PointOfInterestType> CHURCH_ALTAR = POI_TYPES.register("church_altar", () -> (FactionPointOfInterestType)PointOfInterestType.func_221052_a((PointOfInterestType)new FactionPointOfInterestType("no_faction", ModVillage.getAllStates((Block)ModBlocks.CHURCH_ALTAR.get()), 1, 1)));
    public static final RegistryObject<SensorType<VampireVillagerHostilesSensor>> VAMPIRE_VILLAGER_HOSTILES = SENSOR_TYPES.register("vampire_villager_hostiles", () -> new SensorType(VampireVillagerHostilesSensor::new));
    public static final RegistryObject<Schedule> CONVERTED_DEFAULT = SCHEDULES.register("converted_default", () -> new ScheduleBuilder(new Schedule()).func_221402_a(12000, Activity.field_221366_b).func_221402_a(10, Activity.field_221369_e).func_221402_a(14000, Activity.field_221367_c).func_221402_a(21000, Activity.field_221370_f).func_221402_a(23000, Activity.field_221366_b).func_221404_a());
    public static final RegistryObject<VillagerProfession> VAMPIRE_EXPERT = PROFESSIONS.register("vampire_expert", () -> new FactionVillagerProfession("vampire_expert", (PointOfInterestType)VAMPIRE_FACTION.get(), ImmutableSet.of(), ImmutableSet.of(), null){

        @Override
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    });
    public static final RegistryObject<VillagerProfession> HUNTER_EXPERT = PROFESSIONS.register("hunter_expert", () -> new FactionVillagerProfession("hunter_expert", (PointOfInterestType)HUNTER_FACTION.get(), ImmutableSet.of(), ImmutableSet.of(), null){

        @Override
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    });
    public static final RegistryObject<VillagerProfession> PRIEST = PROFESSIONS.register("priest", () -> new VillagerProfession("priest", (PointOfInterestType)CHURCH_ALTAR.get(), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)ModSounds.BLESSING_MUSIC.get()));

    static void registerVillageObjects(IEventBus bus) {
        POI_TYPES.register(bus);
        PROFESSIONS.register(bus);
        SENSOR_TYPES.register(bus);
        SCHEDULES.register(bus);
    }

    public static void villagerTradeSetup() {
        VillagerTrades.field_221239_a.computeIfAbsent(VAMPIRE_EXPERT.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getVampireTrades());
        VillagerTrades.field_221239_a.computeIfAbsent(HUNTER_EXPERT.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getHunterTrades());
        VillagerTrades.field_221239_a.computeIfAbsent(PRIEST.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getPriestTrades());
    }

    private static Set<BlockState> getAllStates(Block ... blocks) {
        return (Set)Arrays.stream(blocks).map(block -> (BlockState)block.func_176194_O().func_177621_b()).collect(ImmutableSet.toImmutableSet());
    }

    private static Map<Integer, VillagerTrades.ITrade[]> getHunterTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForSouls(new Trades.Price(10, 20), (IItemProvider)ModItems.ITEM_GARLIC.get(), new Trades.Price(2, 5)), new Trades.ItemsForSouls(new Trades.Price(30, 40), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), new Trades.Price(1, 1), 6, 1), new Trades.VampireForestTrade(5, 3, 2)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForSouls(new Trades.Price(25, 45), (IItemProvider)Items.field_151045_i, new Trades.Price(1, 1), 2, 5), new Trades.ItemsForSouls(new Trades.Price(10, 20), (IItemProvider)ModItems.CROSSBOW_ARROW_NORMAL.get(), new Trades.Price(5, 15)), new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.SOUL_ORB_VAMPIRE.get(), 10, 10, 4), new Trades.ItemsForSouls(new Trades.Price(30, 40), (IItemProvider)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (IItemProvider)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (IItemProvider)ModItems.HUNTER_COAT_FEET_NORMAL.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (IItemProvider)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), new Trades.Price(1, 1), 6, 1)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForSouls(new Trades.Price(40, 64), (IItemProvider)ModItems.VAMPIRE_BOOK.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), (IItemProvider)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (IItemProvider)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (IItemProvider)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (IItemProvider)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 45), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 45), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(15, 30), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), new Trades.Price(1, 1), 6, 1)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForSouls(new Trades.Price(20, 32), (IItemProvider)Items.field_151045_i, new Trades.Price(1, 2))}, (Object)5, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForSouls(new Trades.Price(30, 55), (IItemProvider)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 55), (IItemProvider)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), (IItemProvider)ModItems.HUNTER_COAT_FEET_ULTIMATE.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), (IItemProvider)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), new Trades.Price(1, 1), 6, 1)});
    }

    private static Map<Integer, VillagerTrades.ITrade[]> getPriestTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModItems.PURE_SALT.get(), 25, 2, 4), new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModItems.ITEM_GARLIC.get(), 30, 6, 2)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HOLY_WATER_BOTTLE_NORMAL.get(), 3, 5, 4), new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModItems.SOUL_ORB_VAMPIRE.get(), 10, 10, 4), new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 9, 4, 5), new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.CRUCIFIX_NORMAL.get(), 1, 1, 1)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), 2, 5, 4)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get(), 1, 4, 4)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), 3, 4, 4)});
    }

    private static Map<Integer, VillagerTrades.ITrade[]> getVampireTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForHeart(new Trades.Price(10, 15), (IItemProvider)ModItems.PURE_BLOOD_0.get(), new Trades.Price(1, 1)), new Trades.BloodBottleForHeart(new Trades.Price(3, 12), new Trades.Price(1, 15), 9), new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModBlocks.VAMPIRE_ORCHID.get(), 4, 1, 3), new Trades.VampireForestTrade(5, 3, 2)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForHeart(new Trades.Price(25, 30), (IItemProvider)ModItems.PURE_BLOOD_1.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(1, 5), (IItemProvider)ModBlocks.COFFIN_RED.get(), new Trades.Price(1, 1), 2, 2), new Trades.ItemsForHeart(new Trades.Price(10, 25), (IItemProvider)ModItems.BLOOD_INFUSED_IRON_INGOT.get(), new Trades.Price(1, 3))}, (Object)3, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (IItemProvider)ModItems.PURE_BLOOD_2.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(15, 30), (IItemProvider)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get(), new Trades.Price(1, 2))}, (Object)4, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForHeart(new Trades.Price(20, 30), (IItemProvider)ModItems.PURE_BLOOD_3.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_RED.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_RED_BLACK.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get())}, new Trades.Price(1, 1), 10, 2)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (IItemProvider)ModItems.PURE_BLOOD_4.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_RED.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_RED_BLACK.get()), new ItemStack((IItemProvider)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get())}, new Trades.Price(1, 1), 10, 2), new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HEART_SEEKER_ULTIMATE.get(), 40, 1, 15), new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HEART_STRIKER_ULTIMATE.get(), 40, 1, 15)});
    }
}

