/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.blocks.VampirismSplitBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.AdjustableLevelCondition;
import de.teamlapen.vampirism.world.loot.RefinementSetFunction;
import de.teamlapen.vampirism.world.loot.SetItemBloodCharge;
import de.teamlapen.vampirism.world.loot.StakeCondition;
import de.teamlapen.vampirism.world.loot.TentSpawnerCondition;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTablesGenerator
extends LootTableProvider {
    public static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public LootTablesGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new ModEntityLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new ModChestLootTables(), (Object)LootParameterSets.field_216261_b), (Object)Pair.of(() -> new ModBlockLootTables(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new InjectLootTables(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        for (ResourceLocation resourcelocation : Sets.difference(ModLootTables.getLootTables(), map.keySet())) {
            validationtracker.func_227530_a_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class InjectLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private InjectLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.abandoned_mineshaft, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)4.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_FANG.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BLOOD_BOTTLE.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(5).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(88))).func_216040_a(LootPool.func_216096_a().name("hunter_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_AXE_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("vampire_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_SEEKER_ENHANCED.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_STRIKER_ENHANCED.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("holy_water").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_NORMAL.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).func_216086_a(10))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.desert_pyramid, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BLOOD_BOTTLE.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.6f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(8).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.jungle_temple, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BLOOD_BOTTLE.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(20).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_FANG.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(30))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))).func_216040_a(LootPool.func_216096_a().name("hunter_coat").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_FEET_ULTIMATE.get())).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_corridor, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(20).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(27))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(80))).func_216040_a(LootPool.func_216096_a().name("vampire_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_SEEKER_ENHANCED.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_STRIKER_ENHANCED.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(80))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_library, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(1).func_212841_b_(AddBookNbt.builder()))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModBlockLootTables
    extends BlockLootTables {
        private ModBlockLootTables() {
        }

        protected void addTables() {
            this.func_218492_c((Block)ModBlocks.ALCHEMICAL_CAULDRON.get());
            this.func_218492_c((Block)ModBlocks.ALTAR_INFUSION.get());
            this.func_218492_c((Block)ModBlocks.ALTAR_INSPIRATION.get());
            this.func_218507_a((Block)ModBlocks.ALTAR_PILLAR.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModBlocks.ALTAR_PILLAR.get())).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221723_cX).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "stone")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221698_bk).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "iron")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221696_bj).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "gold")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221964_gn).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "bone"))))));
            this.func_218492_c((Block)ModBlocks.ALTAR_TIP.get());
            CoffinBlock.COFFIN_BLOCKS.values().forEach(coffin -> this.func_218522_a((Block)coffin, block -> ModBlockLootTables.func_218562_a((Block)block, CoffinBlock.PART, (Comparable)((Object)CoffinBlock.CoffinPart.HEAD))));
            this.func_218492_c((Block)ModBlocks.BLOOD_CONTAINER.get());
            this.func_218492_c((Block)ModBlocks.BLOOD_GRINDER.get());
            this.func_218492_c((Block)ModBlocks.BLOOD_PEDESTAL.get());
            this.func_218492_c((Block)ModBlocks.POTION_TABLE.get());
            this.func_218492_c((Block)ModBlocks.BLOOD_SIEVE.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK_BLOODY.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_BLOCK_DARK_STONE.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_BLOCK_NORMAL_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_BLOCK_PURPLE_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_SLAB_DARK_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_SLAB_DARK_STONE.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_SLAB_PURPLE_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_STAIRS_DARK_BRICK.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_STAIRS_DARK_STONE.get());
            this.func_218492_c((Block)ModBlocks.CASTLE_STAIRS_PURPLE_BRICK.get());
            this.func_218492_c((Block)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get());
            this.func_218492_c((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_PLANKS.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get());
            this.func_218522_a((Block)ModBlocks.DARK_SPRUCE_DOOR.get(), BlockLootTables::func_239829_a_);
            this.func_218522_a((Block)ModBlocks.CURSED_SPRUCE_DOOR.get(), BlockLootTables::func_239829_a_);
            this.func_218492_c((Block)ModBlocks.CHURCH_ALTAR.get());
            this.func_218492_c((Block)ModBlocks.CURSED_EARTH.get());
            this.func_218492_c((Block)ModBlocks.FIRE_PLACE.get());
            this.func_218507_a((Block)ModBlocks.GARLIC.get(), (LootTable.Builder)ModBlockLootTables.func_218552_a((IItemProvider)((IItemProvider)ModBlocks.GARLIC.get()), (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.GARLIC.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)GarlicBlock.field_176488_a, 7))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3))))));
            this.func_218492_c((Block)ModBlocks.GARLIC_BEACON_WEAK.get());
            this.func_218492_c((Block)ModBlocks.GARLIC_BEACON_NORMAL.get());
            this.func_218492_c((Block)ModBlocks.GARLIC_BEACON_IMPROVED.get());
            this.func_218492_c((Block)ModBlocks.HUNTER_TABLE.get());
            this.func_218522_a((Block)ModBlocks.MED_CHAIR.get(), block -> ModBlockLootTables.func_218562_a((Block)block, MedChairBlock.PART, (Comparable)((Object)MedChairBlock.EnumPart.BOTTOM)));
            this.func_218492_c((Block)ModBlocks.SUNSCREEN_BEACON.get());
            this.func_218507_a((Block)ModBlocks.TENT_MAIN.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModItems.ITEM_TENT.get())).func_216040_a(LootPool.func_216096_a().name("bonus").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(TentSpawnerCondition.builder()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151034_e)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151025_P)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196662_n))));
            this.func_218492_c((Block)ModBlocks.TOTEM_BASE.get());
            this.func_218492_c((Block)ModBlocks.TOTEM_TOP_CRAFTED.get());
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModBlocks.TOTEM_TOP_CRAFTED.get())));
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModBlocks.TOTEM_TOP_CRAFTED.get())));
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP.get(), ModBlockLootTables.func_218482_a());
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get(), ModBlockLootTables.func_218482_a());
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), ModBlockLootTables.func_218482_a());
            this.func_218492_c((Block)ModBlocks.VAMPIRE_ORCHID.get());
            this.func_218492_c((Block)ModBlocks.WEAPON_TABLE.get());
            this.func_218507_a((Block)ModBlocks.TENT.get(), ModBlockLootTables.func_218482_a());
            this.func_218547_a((Block)ModBlocks.POTTED_VAMPIRE_ORCHID.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_SAPLING.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get());
            this.func_218522_a((Block)ModBlocks.DARK_SPRUCE_LEAVES.get(), block -> ModBlockLootTables.func_218540_a((Block)block, (Block)((Block)ModBlocks.DARK_SPRUCE_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218492_c((Block)ModBlocks.CHANDELIER.get());
            this.func_218507_a((Block)ModBlocks.CANDELABRA_WALL.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModItems.ITEM_CANDELABRA.get())));
            this.func_218507_a((Block)ModBlocks.CANDELABRA.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModItems.ITEM_CANDELABRA.get())));
            this.func_218522_a((Block)ModBlocks.CROSS.get(), p_218567_0_ -> ModBlockLootTables.func_218562_a((Block)p_218567_0_, VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.func_218492_c((Block)ModBlocks.TOMBSTONE1.get());
            this.func_218492_c((Block)ModBlocks.TOMBSTONE2.get());
            this.func_218522_a((Block)ModBlocks.TOMBSTONE3.get(), context -> ModBlockLootTables.func_218562_a((Block)context, VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.func_218492_c((Block)ModBlocks.GRAVE_CAGE.get());
            this.func_218507_a((Block)ModBlocks.CURSED_GRASS.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)ModBlocks.CURSED_EARTH.get())));
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_LOG.get());
            this.func_218522_a((Block)ModBlocks.CURSED_ROOTS.get(), block -> ModBlockLootTables.func_218511_b((Block)block, (LootEntry.Builder)((LootEntry.Builder)ModBlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f)))))));
            this.func_218547_a((Block)ModBlocks.POTTED_CURSED_ROOTS.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_LOG.get());
            this.func_218507_a((Block)ModBlocks.CURSED_BARK.get(), ModBlockLootTables.func_218482_a());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_STAIRS.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_STAIRS.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_WOOD.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_WOOD.get());
            this.func_218492_c((Block)ModBlocks.STRIPPED_DARK_SPRUCE_WOOD.get());
            this.func_218492_c((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_WOOD.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_SIGN.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_SIGN.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_WALL_SIGN.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_WALL_SIGN.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_PRESSURE_PLACE.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_PRESSURE_PLACE.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_BUTTON.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_BUTTON.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_SLAB.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_SLAB.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_FENCE_GATE.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_FENCE_GATE.get());
            this.func_218492_c((Block)ModBlocks.DARK_SPRUCE_FENCE.get());
            this.func_218492_c((Block)ModBlocks.CURSED_SPRUCE_FENCE.get());
            this.func_218492_c((Block)ModBlocks.VAMPIRE_RACK.get());
            this.func_218522_a((Block)ModBlocks.THRONE.get(), p_218567_0_ -> ModBlockLootTables.func_218562_a((Block)p_218567_0_, VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.func_218492_c((Block)ModBlocks.ALCHEMY_TABLE.get());
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }

    private static class ModChestLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private ModChestLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.chest_hunter_trainer, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)9.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("book").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(50).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("hunter_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_AXE_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("hunter_coat").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUNTER_COAT_FEET_ULTIMATE.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("holy_water").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_SALT.get())).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_NORMAL.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).func_216086_a(10))));
            consumer.accept(ModLootTables.chest_vampire_dungeon, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)7)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_FANG.get())).func_216086_a(35)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BLOOD_BOTTLE.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().name("book").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(70).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(30))).func_216040_a(LootPool.func_216096_a().name("equipment").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_SEEKER_ENHANCED.get())).func_216086_a(21).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_SEEKER_ULTIMATE.get())).func_216086_a(9).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_STRIKER_ENHANCED.get())).func_216086_a(21).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HEART_STRIKER_ULTIMATE.get())).func_216086_a(9).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootTables {
        private ModEntityLootTables() {
        }

        protected void addTables() {
            CompoundNBT splash = new CompoundNBT();
            splash.func_74757_a("splash", true);
            LootTable.Builder advanced_hunter = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ITEM_GARLIC.get())).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)splash))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)splash))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_SALT_WATER.get())).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_216040_a(LootPool.func_216096_a().name("special").func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.01f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(1).func_212841_b_(AddBookNbt.builder())));
            this.func_218582_a((EntityType)ModEntities.ADVANCED_HUNTER.get(), advanced_hunter);
            this.func_218582_a((EntityType)ModEntities.ADVANCED_HUNTER_IMOB.get(), advanced_hunter);
            LootTable.Builder advanced_vampire = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BLOOD_BOTTLE.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.5f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().name("special").func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.1f, (float)0.01f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BOOK.get())).func_216086_a(1).func_212841_b_(AddBookNbt.builder()))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.01f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.func_218582_a((EntityType)ModEntities.ADVANCED_VAMPIRE.get(), advanced_vampire);
            this.func_218582_a((EntityType)ModEntities.ADVANCED_VAMPIRE_IMOB.get(), advanced_vampire);
            this.func_218582_a((EntityType)ModEntities.BLINDING_BAT.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_CREATURE.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_SHEEP.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_COW.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_HORSE.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_DONKEY.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.CONVERTED_MULE.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.DUMMY_CREATURE.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.HUNTER_TRAINER.get(), LootTable.func_216119_b());
            LootTable.Builder vampire = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_FANG.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("special").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(StakeCondition.builder(LootContext.EntityTarget.KILLER_PLAYER)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.5f, (float)0.05f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.02f, (float)0.01f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.func_218582_a((EntityType)ModEntities.VAMPIRE.get(), vampire);
            this.func_218582_a((EntityType)ModEntities.VAMPIRE_IMOB.get(), vampire);
            this.func_218582_a((EntityType)ModEntities.VAMPIRE_BARON.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("pure_blood_0").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(0, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_BLOOD_0.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_1").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(1, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_BLOOD_1.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_2").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(2, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_BLOOD_2.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_3").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(3, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_BLOOD_3.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_4").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(4, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PURE_BLOOD_4.get())).func_216086_a(1))));
            LootTable.Builder hunter = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.005f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.HUMAN_HEART.get())).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("refinement_item").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.02f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AMULET.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.RING.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.OBI_BELT.get())).func_216086_a(1).func_212841_b_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.func_218582_a((EntityType)ModEntities.HUNTER.get(), hunter);
            this.func_218582_a((EntityType)ModEntities.HUNTER_IMOB.get(), hunter);
            this.func_218582_a((EntityType)ModEntities.VILLAGER_ANGRY.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.VILLAGER_CONVERTED.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.TASK_MASTER_HUNTER.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.VAMPIRE_MINION.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.HUNTER_MINION.get(), LootTable.func_216119_b());
        }

        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.getAllEntities();
        }
    }
}

