/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.data.recipebuilder.FinishedSkillNode;
import de.teamlapen.vampirism.data.recipebuilder.SkillNodeBuilder;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillNodeGenerator
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public SkillNodeGenerator(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.registerSkillNodes(node -> {
            if (!set.add(node.getID())) {
                throw new IllegalStateException("Duplicate skill node " + node.getID());
            }
            this.saveSkillNode(cache, node.getSkillNodeJson(), path.resolve("data/" + node.getID().func_110624_b() + "/vampirismskillnodes/" + node.getID().func_110623_a() + ".json"));
        });
    }

    public String func_200397_b() {
        return "Vampirism skillnode generator";
    }

    protected void registerSkillNodes(Consumer<FinishedSkillNode> consumer) {
        ResourceLocation skill2 = SkillNodeBuilder.hunter(this.modId("hunter"), (ISkill)HunterSkills.STAKE1.get()).build(consumer, this.modId("skill2"));
        ResourceLocation skill3 = SkillNodeBuilder.hunter(skill2, (ISkill)HunterSkills.WEAPON_TABLE.get()).build(consumer, this.modId("skill3"));
        ResourceLocation skill4 = SkillNodeBuilder.hunter(skill3, (ISkill)HunterSkills.HUNTER_DISGUISE.get()).build(consumer, this.modId("skill4"));
        ResourceLocation alchemy1 = SkillNodeBuilder.hunter(skill4, (ISkill)HunterSkills.BASIC_ALCHEMY.get()).build(consumer, this.modId("alchemy1"));
        ResourceLocation alchemy2 = SkillNodeBuilder.hunter(alchemy1, (ISkill)HunterSkills.GARLIC_BEACON.get()).build(consumer, this.modId("alchemy2"));
        ResourceLocation alchemy3 = SkillNodeBuilder.hunter(alchemy2, (ISkill)HunterSkills.CRUCIFIX_WIELDER.get()).build(consumer, this.modId("alchemy3"));
        ResourceLocation alchemy4 = SkillNodeBuilder.hunter(alchemy3, (ISkill)HunterSkills.PURIFIED_GARLIC.get(), (ISkill)HunterSkills.ENHANCED_BLESSING.get()).build(consumer, this.modId("alchemy4"));
        ResourceLocation alchemy5 = SkillNodeBuilder.hunter(alchemy4, (ISkill)HunterSkills.GARLIC_BEACON_IMPROVED.get(), (ISkill)HunterSkills.ULTIMATE_CRUCIFIX.get()).build(consumer, this.modId("alchemy5"));
        ResourceLocation alchemy6 = SkillNodeBuilder.hunter(alchemy5, (ISkill)HunterSkills.HUNTER_AWARENESS.get()).build(consumer, this.modId("alchemy6"));
        ResourceLocation potion1 = SkillNodeBuilder.hunter(skill4, (ISkill)HunterSkills.MULTITASK_BREWING.get()).build(consumer, this.modId("potion1"));
        ResourceLocation potion2 = SkillNodeBuilder.hunter(potion1, (ISkill)HunterSkills.DURABLE_BREWING.get(), (ISkill)HunterSkills.CONCENTRATED_BREWING.get()).build(consumer, this.modId("potion2"));
        ResourceLocation potion3 = SkillNodeBuilder.hunter(potion2, (ISkill)HunterSkills.SWIFT_BREWING.get(), (ISkill)HunterSkills.EFFICIENT_BREWING.get()).build(consumer, this.modId("potion3"));
        ResourceLocation potion4 = SkillNodeBuilder.hunter(potion3, (ISkill)HunterSkills.MASTER_BREWER.get()).build(consumer, this.modId("potion4"));
        ResourceLocation potion5 = SkillNodeBuilder.hunter(potion4, (ISkill)HunterSkills.POTION_RESISTANCE.get()).build(consumer, this.modId("potion5"));
        ResourceLocation potion6 = SkillNodeBuilder.hunter(potion5, (ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get()).build(consumer, this.modId("potion6"));
        ResourceLocation weapon1 = SkillNodeBuilder.hunter(skill4, (ISkill)HunterSkills.HUNTER_ATTACK_SPEED.get(), (ISkill)HunterSkills.HUNTER_ATTACK_DAMAGE.get()).build(consumer, this.modId("weapon1"));
        ResourceLocation weapon2 = SkillNodeBuilder.hunter(weapon1, (ISkill)HunterSkills.DOUBLE_CROSSBOW.get()).build(consumer, this.modId("weapon2"));
        ResourceLocation weapon3 = SkillNodeBuilder.hunter(weapon2, (ISkill)HunterSkills.HUNTER_ATTACK_SPEED_ADVANCED.get(), (ISkill)HunterSkills.ENHANCED_WEAPONS.get()).build(consumer, this.modId("weapon3"));
        ResourceLocation weapon4 = SkillNodeBuilder.hunter(weapon3, (ISkill)HunterSkills.ENHANCED_ARMOR.get()).build(consumer, this.modId("weapon4"));
        ResourceLocation weapon5 = SkillNodeBuilder.hunter(weapon4, (ISkill)HunterSkills.TECH_WEAPONS.get()).build(consumer, this.modId("weapon5"));
        ResourceLocation weapon6 = SkillNodeBuilder.hunter(weapon5, (ISkill)HunterSkills.STAKE2.get()).build(consumer, this.modId("weapon6"));
        ResourceLocation lord_2 = SkillNodeBuilder.hunter(this.modId("hunter_lord"), (ISkill)HunterSkills.HUNTER_MINION_STATS_INCREASE.get()).build(consumer, this.modId("lord_2"));
        ResourceLocation lord_3 = SkillNodeBuilder.hunter(this.modId("hunter_lord"), (ISkill)HunterSkills.HUNTER_LORD_SPEED.get(), (ISkill)HunterSkills.HUNTER_LORD_ATTACK_SPEED.get()).build(consumer, this.modId("lord_3"));
        ResourceLocation lord_4 = SkillNodeBuilder.hunter(this.modId("hunter_lord"), (ISkill)HunterSkills.HUNTER_MINION_COLLECT.get()).build(consumer, this.modId("lord_4"));
        ResourceLocation lord_5 = SkillNodeBuilder.hunter(this.modId("hunter_lord"), (ISkill)HunterSkills.HUNTER_MINION_RECOVERY.get()).build(consumer, this.modId("lord_5"));
        ResourceLocation resourceLocation = SkillNodeBuilder.hunter(lord_2, (ISkill)HunterSkills.MINION_TECH_CROSSBOWS.get()).build(consumer, this.modId("lord_6"));
        skill2 = SkillNodeBuilder.vampire(this.modId("vampire"), (ISkill)VampireSkills.NIGHT_VISION.get()).build(consumer, this.modId("skill2"));
        skill3 = SkillNodeBuilder.vampire(skill2, (ISkill)VampireSkills.VAMPIRE_REGENERATION.get()).build(consumer, this.modId("skill3"));
        skill4 = SkillNodeBuilder.vampire(skill3, (ISkill)VampireSkills.FLEDGLING.get()).build(consumer, this.modId("skill4"));
        ResourceLocation util1 = SkillNodeBuilder.vampire(skill4, (ISkill)VampireSkills.SUMMON_BATS.get()).build(consumer, this.modId("util1"));
        ResourceLocation util15 = SkillNodeBuilder.vampire(util1, (ISkill)VampireSkills.HISSING.get()).build(consumer, this.modId("util15"));
        ResourceLocation util2 = SkillNodeBuilder.vampire(util1, (ISkill)VampireSkills.LESS_SUNDAMAGE.get(), (ISkill)VampireSkills.WATER_RESISTANCE.get()).build(consumer, this.modId("util2"));
        ResourceLocation util3 = SkillNodeBuilder.vampire(util2, (ISkill)VampireSkills.LESS_BLOOD_THIRST.get()).build(consumer, this.modId("util3"));
        ResourceLocation util4 = SkillNodeBuilder.vampire(util3, (ISkill)VampireSkills.VAMPIRE_DISGUISE.get()).build(consumer, this.modId("util4"));
        ResourceLocation util5 = SkillNodeBuilder.vampire(util4, (ISkill)VampireSkills.HALF_INVULNERABLE.get()).build(consumer, this.modId("util5"));
        ResourceLocation util6 = SkillNodeBuilder.vampire(util5, (ISkill)VampireSkills.VAMPIRE_INVISIBILITY.get()).build(consumer, this.modId("util6"));
        ResourceLocation offensive1 = SkillNodeBuilder.vampire(skill4, (ISkill)VampireSkills.VAMPIRE_RAGE.get()).build(consumer, this.modId("offensive1"));
        ResourceLocation offensive2 = SkillNodeBuilder.vampire(offensive1, (ISkill)VampireSkills.ADVANCED_BITER.get()).build(consumer, this.modId("offensive2"));
        ResourceLocation offensive3 = SkillNodeBuilder.vampire(offensive2, (ISkill)VampireSkills.SWORD_FINISHER.get()).build(consumer, this.modId("offensive3"));
        ResourceLocation offensive4 = SkillNodeBuilder.vampire(offensive3, (ISkill)VampireSkills.DARK_BLOOD_PROJECTILE.get()).build(consumer, this.modId("offensive4"));
        ResourceLocation offensive5 = SkillNodeBuilder.vampire(offensive4, (ISkill)VampireSkills.BLOOD_CHARGE.get()).build(consumer, this.modId("offensive5"));
        ResourceLocation offensive6 = SkillNodeBuilder.vampire(offensive5, (ISkill)VampireSkills.FREEZE.get()).build(consumer, this.modId("offensive6"));
        ResourceLocation defensive1 = SkillNodeBuilder.vampire(skill4, (ISkill)VampireSkills.SUNSCREEN.get()).build(consumer, this.modId("defensive1"));
        ResourceLocation defensive2 = SkillNodeBuilder.vampire(defensive1, (ISkill)VampireSkills.VAMPIRE_ATTACK_SPEED.get(), (ISkill)VampireSkills.VAMPIRE_SPEED.get()).build(consumer, this.modId("defensive2"));
        ResourceLocation defensive3 = SkillNodeBuilder.vampire(defensive2, (ISkill)VampireSkills.BLOOD_VISION.get()).build(consumer, this.modId("defensive3"));
        ResourceLocation defensive4_1 = SkillNodeBuilder.vampire(defensive3, (ISkill)VampireSkills.VAMPIRE_ATTACK_DAMAGE.get(), (ISkill)VampireSkills.VAMPIRE_JUMP.get()).build(consumer, this.modId("defensive5"));
        ResourceLocation defensive4_2 = SkillNodeBuilder.vampire(defensive3, (ISkill)VampireSkills.BLOOD_VISION_GARLIC.get()).build(consumer, this.modId("defensive4"));
        ResourceLocation defensive5 = SkillNodeBuilder.vampire(defensive4_1, (ISkill)VampireSkills.NEONATAL_DECREASE.get(), (ISkill)VampireSkills.DBNO_DURATION.get()).build(consumer, this.modId("defensive6"));
        ResourceLocation defensive6 = SkillNodeBuilder.vampire(defensive5, (ISkill)VampireSkills.TELEPORT.get()).build(consumer, this.modId("defensive7"));
        ResourceLocation lord_22 = SkillNodeBuilder.vampire(this.modId("vampire_lord"), (ISkill)VampireSkills.VAMPIRE_MINION_STATS_INCREASE.get()).build(consumer, this.modId("lord_2"));
        ResourceLocation lord_32 = SkillNodeBuilder.vampire(this.modId("vampire_lord"), (ISkill)VampireSkills.VAMPIRE_LORD_SPEED.get(), (ISkill)VampireSkills.VAMPIRE_LORD_ATTACK_SPEED.get()).build(consumer, this.modId("lord_3"));
        ResourceLocation lord_42 = SkillNodeBuilder.vampire(this.modId("vampire_lord"), (ISkill)VampireSkills.VAMPIRE_MINION_COLLECT.get()).build(consumer, this.modId("lord_4"));
        ResourceLocation resourceLocation2 = SkillNodeBuilder.vampire(this.modId("vampire_lord"), (ISkill)VampireSkills.VAMPIRE_MINION_RECOVERY.get()).build(consumer, this.modId("lord_5"));
    }

    private ResourceLocation modId(String string) {
        return new ResourceLocation("vampirism", string);
    }

    private void saveSkillNode(DirectoryCache cache, JsonObject nodeJson, Path path) {
        try {
            String s = GSON.toJson((JsonElement)nodeJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(s);
                }
            }
            cache.func_208316_a(path, s1);
        }
        catch (IOException ioExeption) {
            LOGGER.error("Couldn't save skill node {}", (Object)path, (Object)ioExeption);
        }
    }
}

