/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OblivionEffect
extends VampirismEffect {
    private static final Logger LOGGER = LogManager.getLogger();

    public OblivionEffect(EffectType effectType, int potionColor) {
        super(effectType, potionColor);
    }

    @Override
    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    @Override
    public void func_76394_a(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (!entityLivingBaseIn.func_130014_f_().field_72995_K && entityLivingBaseIn instanceof PlayerEntity) {
            entityLivingBaseIn.func_195064_c(new EffectInstance(Effects.field_76431_k, this.getTickDuration(amplifier), 5, false, false, false, null));
            FactionPlayerHandler.getOpt((PlayerEntity)entityLivingBaseIn).map(FactionPlayerHandler::getCurrentFactionPlayer).flatMap(factionPlayer -> factionPlayer).ifPresent(factionPlayer -> {
                ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                Optional<SkillNode> nodeOPT = ((SkillHandler)skillHandler).anyLastNode();
                if (nodeOPT.isPresent()) {
                    for (ISkill element : nodeOPT.get().getElements()) {
                        skillHandler.disableSkill(element);
                    }
                } else {
                    entityLivingBaseIn.func_195063_d((Effect)ModEffects.OBLIVION.get());
                    ((PlayerEntity)entityLivingBaseIn).func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.skill.skills_reset"), true);
                    LOGGER.debug(LogUtil.FACTION, "Skills were reset for {}", (Object)entityLivingBaseIn.func_200200_C_().getString());
                    VampirismLogger.info(VampirismLogger.SKILLS, "Skills were reset for {}", entityLivingBaseIn.func_200200_C_().getString());
                }
            });
        }
    }

    @Override
    public boolean func_76397_a(int duration, int amplifier) {
        return duration % this.getTickDuration(amplifier) == 0;
    }

    private int getTickDuration(int amplifier) {
        return 1000 / (amplifier + 1);
    }
}

