/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class DamageHandler {
    public static void affectVampireGarlicSplash(IVampire vampire, EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(IVampire vampire, EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(IVampire vampire, EnumStrength strength, float multiplier, boolean ambient) {
        if (strength == EnumStrength.NONE) {
            return;
        }
        LivingEntity entity = vampire.getRepresentingEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GARLIC.get(), (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76437_t, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.func_195064_c(new EffectInstance(Effects.field_76440_q, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer) {
            IActionHandler<IVampirePlayer> actionHandler = ((IVampirePlayer)vampire).getActionHandler();
            actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
        }
    }

    public static void affectVampireGarlicAmbient(IVampire vampire, EnumStrength strength, int ticks) {
        if (ticks % 37 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit) {
        DamageHandler.affectEntityHolyWaterSplash(entity, strength, distSq, directHit, null);
    }

    public static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit, @Nullable LivingEntity source) {
        IActionHandlerEntity h;
        if (!entity.func_70089_S()) {
            return;
        }
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.func_184603_cC() && (vampire || CreatureAttribute.field_223223_b_.equals(entity.func_70668_bt())) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            if (entity instanceof PlayerEntity) {
                int l = VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)entity)).vampireLevel;
                amount = DamageHandler.scaleDamageWithLevel(l, 14, amount * 0.8, amount * 1.3);
            } else if (entity instanceof VampireBaronEntity) {
                int l = ((VampireBaronEntity)entity).getLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 4, amount * 0.8, amount * 2.0);
            }
            entity.func_70097_a(VReference.HOLY_WATER, (float)amount);
        }
        if (vampire && entity instanceof PlayerEntity) {
            VampirePlayer.getOpt((PlayerEntity)entity).map(VampirePlayer::getActionHandler).ifPresent(actionHandler -> {
                actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
                actionHandler.deactivateAction((ILastingAction)VampireActions.VAMPIRE_INVISIBILITY.get());
            });
        } else if (vampire && entity instanceof IEntityActionUser && (h = ((IEntityActionUser)entity).getActionHandler()).isActionActive((IEntityAction)EntityActions.ENTITY_INVISIBLE.get())) {
            h.deactivateAction();
        }
        if (vampire) {
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76431_k, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76440_q, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }

    public static double scaleDamageWithLevel(int level, int maxLevel, double minDamage, double maxDamage) {
        return minDamage + (double)level / (double)maxLevel * (maxDamage - minDamage);
    }
}

