/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DarkBloodProjectileEntity
extends DamagingProjectileEntity {
    protected float directDamage = 4.0f;
    protected float indirectDamage = 2.0f;
    private boolean initialNoClip = false;
    private float motionFactor = 0.97f;
    private boolean excludeShooter = false;
    private boolean gothrough;
    private int maxTicks = 40;

    public DarkBloodProjectileEntity(EntityType<? extends DarkBloodProjectileEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DarkBloodProjectileEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntities.DARK_BLOOD_PROJECTILE.get(), shooter, accelX, accelY, accelZ, worldIn);
    }

    public DarkBloodProjectileEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntities.DARK_BLOOD_PROJECTILE.get(), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("direct_damage", this.directDamage);
        compound.func_74776_a("indirect_damage", this.indirectDamage);
        compound.func_74757_a("gothrough", this.gothrough);
        compound.func_74768_a("max_ticks", this.maxTicks);
        compound.func_74776_a("motion_factor", this.motionFactor);
    }

    public void explode(int distanceSq, @Nullable Entity excludeEntity) {
        Entity shootingEntity = this.func_234616_v_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)distanceSq / 2.0), EntityPredicates.field_94557_a.and(EntityPredicates.field_180132_d));
        for (Entity e : list) {
            if (this.excludeShooter && e == shootingEntity || e == excludeEntity || !(e instanceof LivingEntity) || !(e.func_70068_e((Entity)this) < (double)distanceSq)) continue;
            LivingEntity entity = (LivingEntity)e;
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
            entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.func_234616_v_()), this.indirectDamage);
        }
        if (!this.field_70170_p.field_72995_K) {
            ModParticles.spawnParticlesServer(this.field_70170_p, new GenericParticleData((ParticleType<GenericParticleData>)((ParticleType)ModParticles.GENERIC.get()), new ResourceLocation("minecraft", "spell_1"), 7, 0xA01010, 0.2f), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 40, 1.0, 1.0, 1.0, 0.0);
            ModParticles.spawnParticlesServer(this.field_70170_p, new GenericParticleData((ParticleType<GenericParticleData>)((ParticleType)ModParticles.GENERIC.get()), new ResourceLocation("minecraft", "spell_6"), 10, 0x700505), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 15, 1.0, 1.0, 1.0, 0.0);
        }
        this.func_70106_y();
    }

    public void excludeShooter() {
        this.excludeShooter = true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float func_70111_Y() {
        return 0.5f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void setDamage(float direct, float indirect) {
        this.directDamage = direct;
        this.indirectDamage = indirect;
    }

    public void setGothrough(boolean gothrough) {
        this.gothrough = gothrough;
    }

    public void setInitialNoClip() {
        this.initialNoClip = true;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.directDamage = compound.func_74760_g("direct_damage");
        this.indirectDamage = compound.func_74760_g("indirect_damage");
        this.gothrough = compound.func_74767_n("gothrough");
        this.maxTicks = compound.func_74762_e("max_ticks");
        this.motionFactor = compound.func_74760_g("motion_factor");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            Vector3d center = this.func_213303_ch();
            ModParticles.spawnParticlesClient(this.field_70170_p, new GenericParticleData((ParticleType<GenericParticleData>)((ParticleType)ModParticles.GENERIC.get()), new ResourceLocation("minecraft", "spell_4"), 4, 0xA01010, 0.0f), center.field_72450_a, center.field_72448_b, center.field_72449_c, 5, this.func_70111_Y(), this.field_70146_Z);
            if (this.field_70173_aa % 3 == 0) {
                ModParticles.spawnParticleClient(this.field_70170_p, new GenericParticleData((ParticleType<GenericParticleData>)((ParticleType)ModParticles.GENERIC.get()), new ResourceLocation("minecraft", "effect_4"), 12, 0xC01010, 0.4f), center.field_72450_a, center.field_72448_b, center.field_72449_c);
            }
        }
        if (this.field_70173_aa > this.maxTicks) {
            if (!this.field_70170_p.func_201670_d()) {
                this.explode(4, null);
            } else {
                this.func_70106_y();
            }
        }
    }

    protected float func_82341_c() {
        return this.motionFactor;
    }

    public void setMotionFactor(float factor) {
        this.motionFactor = factor;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197605_P;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.initialNoClip && this.field_70173_aa > 20 && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return;
            }
            Entity entity = null;
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                entity = ((EntityRayTraceResult)result).func_216348_a();
                if (entity instanceof DarkBloodProjectileEntity) {
                    return;
                }
                this.hitEntity(entity);
            }
            if (!this.gothrough) {
                this.explode(4, entity);
            }
        }
    }

    protected boolean func_184564_k() {
        return false;
    }

    private void hitEntity(Entity entity) {
        entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.func_234616_v_()), this.directDamage);
        if (entity instanceof LivingEntity && this.field_70146_Z.nextInt(3) == 0) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, 100));
            ((LivingEntity)entity).func_233627_a_(1.0f, -this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72449_c);
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
        }
    }
}

