/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.ExtendedCreatureDefaultImpl;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ExtendedCreature
implements ISyncable.ISyncableEntityCapabilityInst,
IExtendedCreatureVampirism {
    private static final String KEY_BLOOD = "bloodLevel";
    private static final String KEY_MAX_BLOOD = "maxBlood";
    private static final String POISONOUS_BLOOD = "poisonousBlood";
    @CapabilityInject(value=IExtendedCreatureVampirism.class)
    public static Capability<IExtendedCreatureVampirism> CAP = (Capability)UtilLib.getNull();
    private final CreatureEntity entity;
    private final boolean canBecomeVampire;
    private boolean poisonousBlood;
    private boolean markForBloodCalculation = false;
    private int maxBlood;
    private int blood;
    private int remainingBarkTicks;

    public static LazyOptional<IExtendedCreatureVampirism> getSafe(Entity mob) {
        return mob.getCapability(CAP);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IExtendedCreatureVampirism.class, (Capability.IStorage)new Storage(), ExtendedCreatureDefaultImpl::new);
    }

    static <Q extends CreatureEntity> ICapabilityProvider createNewCapability(final Q creature) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final Function<Q, IExtendedCreatureVampirism> constructor;
            final IExtendedCreatureVampirism inst;
            final LazyOptional<IExtendedCreatureVampirism> opt;
            {
                this.constructor = VampirismAPI.entityRegistry().getCustomExtendedCreatureConstructor(creature);
                this.inst = this.constructor == null ? new ExtendedCreature(creature) : this.constructor.apply(creature);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public ExtendedCreature(CreatureEntity entity) {
        this.entity = entity;
        BiteableEntry entry = VampirismAPI.entityRegistry().getEntry(entity);
        if (entry != null && entry.blood > 0) {
            this.maxBlood = entry.blood;
            this.canBecomeVampire = entry.convertible;
        } else {
            if (entry == null) {
                this.markForBloodCalculation = true;
            }
            this.maxBlood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.maxBlood;
        this.poisonousBlood = false;
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return this.getBlood() > 0;
    }

    @Override
    public boolean canBecomeVampire() {
        return this.canBecomeVampire;
    }

    @Override
    public int getBlood() {
        return this.blood;
    }

    @Override
    public void setBlood(int blood) {
        if (blood >= 0 && blood <= this.getMaxBlood() && this.getBlood() != -1) {
            this.blood = blood;
        }
    }

    @Override
    public float getBloodLevelRelative() {
        return (float)this.getBlood() / (float)this.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.EXTENDED_CREATURE_KEY;
    }

    @Override
    public CreatureEntity getEntity() {
        return this.entity;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int blood) {
        this.maxBlood = blood;
        this.blood = blood;
    }

    @Override
    public int getTheEntityID() {
        return this.entity.func_145782_y();
    }

    @Override
    public boolean hasPoisonousBlood() {
        return this.poisonousBlood;
    }

    @Override
    public void loadUpdateFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b(KEY_BLOOD)) {
            this.setBlood(nbt.func_74762_e(KEY_BLOOD));
        }
        if (nbt.func_74764_b(KEY_MAX_BLOOD)) {
            this.setBlood(nbt.func_74762_e(KEY_MAX_BLOOD));
        }
        if (nbt.func_74764_b(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(nbt.func_74767_n(POISONOUS_BLOOD));
        }
    }

    @Override
    @Nullable
    public IConvertedCreature makeVampire() {
        if (this.canBecomeVampire()) {
            this.blood = -1;
            IConvertedCreature c = VampirismAPI.entityRegistry().convert(this.entity);
            if (c != null) {
                UtilLib.replaceEntity((LivingEntity)this.entity, (LivingEntity)((CreatureEntity)c));
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean canBeInfected(IVampire vampire) {
        return this.canBecomeVampire && !this.hasPoisonousBlood();
    }

    @Override
    public boolean tryInfect(IVampire vampire) {
        if (this.canBeInfected(vampire)) {
            SanguinareEffect.addRandom((LivingEntity)this.entity, false);
            return true;
        }
        return false;
    }

    @Override
    public int onBite(IVampire biter) {
        if (this.getBlood() <= 0) {
            return 0;
        }
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= this.blood) {
            amt = this.blood > 1 && biter.isAdvancedBiter() ? this.blood - 1 : this.blood;
        }
        this.blood -= amt;
        if (this.blood == 0) {
            this.entity.func_70097_a(VReference.NO_BLOOD, 1000.0f);
        }
        this.sync();
        this.entity.func_70604_c(biter.getRepresentingEntity());
        if (this.entity instanceof AgeableEntity && ((AgeableEntity)this.entity).func_70874_b() < 0) {
            amt = Math.round((float)amt / 3.0f);
        }
        if (biter.isAdvancedBiter() && this.entity.func_70681_au().nextInt(4) == 0) {
            amt = 2 * amt;
        }
        return amt;
    }

    @Override
    public void setPoisonousBlood(boolean poisonous) {
        if (poisonous == !this.poisonousBlood) {
            this.poisonousBlood = poisonous;
            this.sync();
        }
    }

    public int getRemainingBarkTicks() {
        return this.remainingBarkTicks;
    }

    public void increaseRemainingBarkTicks(int additionalBarkTicks) {
        this.remainingBarkTicks += additionalBarkTicks;
    }

    @Override
    public void tick() {
        if (!this.entity.func_130014_f_().field_72995_K) {
            if (this.blood == 0 && this.entity.field_70173_aa % 20 == 10 && this.entity.func_70660_b((Effect)ModEffects.SANGUINARE.get()) == null) {
                this.entity.func_70097_a(VReference.NO_BLOOD, 1000.0f);
            }
            if (this.blood > 0 && this.blood < this.getMaxBlood() && this.entity.field_70173_aa % 40 == 8) {
                this.entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 41));
                this.entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 41, 2));
                if (this.entity.func_70681_au().nextInt(BalanceMobProps.mobProps.BLOOD_REGEN_CHANCE) == 0) {
                    this.setBlood(this.getBlood() + 1);
                    this.sync();
                }
            }
        }
        if (this.markForBloodCalculation && VampirismEntityRegistry.biteableEntryManager.init()) {
            BiteableEntry entry = VampirismEntityRegistry.biteableEntryManager.calculate(this.entity);
            if (entry != null) {
                this.setMaxBlood(entry.blood);
            }
            this.markForBloodCalculation = false;
        }
        if (this.remainingBarkTicks > 0) {
            --this.remainingBarkTicks;
        }
    }

    public String toString() {
        return super.toString() + " for entity (" + this.entity.toString() + ") [B" + this.blood + ",MB" + this.maxBlood + ",CV" + this.canBecomeVampire + "]";
    }

    @Override
    public void writeFullUpdateToNBT(CompoundNBT nbt) {
        nbt.func_74768_a(KEY_BLOOD, this.getBlood());
        nbt.func_74768_a(KEY_MAX_BLOOD, this.getBlood());
        nbt.func_74757_a(POISONOUS_BLOOD, this.hasPoisonousBlood());
    }

    private void loadNBTData(CompoundNBT compound) {
        if (compound.func_74764_b(KEY_MAX_BLOOD)) {
            this.setMaxBlood(compound.func_74762_e(KEY_MAX_BLOOD));
        }
        if (compound.func_74764_b(KEY_BLOOD)) {
            this.setBlood(compound.func_74762_e(KEY_BLOOD));
        }
        if (compound.func_74764_b(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(compound.func_74767_n(POISONOUS_BLOOD));
        }
    }

    private void saveNBTData(CompoundNBT compound) {
        compound.func_74768_a(KEY_BLOOD, this.blood);
        compound.func_74768_a(KEY_MAX_BLOOD, this.maxBlood);
        compound.func_74757_a(POISONOUS_BLOOD, this.poisonousBlood);
    }

    public void sync() {
        HelperLib.sync(this, (Entity)this.getEntity(), false);
    }

    private void sync(CompoundNBT data) {
        HelperLib.sync(this, data, (Entity)this.getEntity(), false);
    }

    private static class Storage
    implements Capability.IStorage<IExtendedCreatureVampirism> {
        private Storage() {
        }

        public void readNBT(Capability<IExtendedCreatureVampirism> capability, IExtendedCreatureVampirism instance, Direction side, INBT nbt) {
            ((ExtendedCreature)instance).loadNBTData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IExtendedCreatureVampirism> capability, IExtendedCreatureVampirism instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((ExtendedCreature)instance).saveNBTData(nbt);
            return nbt;
        }
    }
}

