/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.CastleSlabBlock;
import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.goals.GolemTargetNonVillageFactionGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEntityEventHandler.class);
    private static final Predicate<LivingEntity> nonVampireCheck = entity -> !Helper.isVampire((Entity)entity);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private final Set<ResourceLocation> unknownZombies = new HashSet<ResourceLocation>();
    private boolean warnAboutGolem = true;

    public static <T extends MobEntity, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeVampireFriendly(String name, T e, Class<Q> targetClass, Class<S> targetEntityClass, int attackPriority, BiFunction<T, Predicate<LivingEntity>, Q> replacement, Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (PrioritizedGoal t : e.field_70715_bh.field_220892_d) {
            Goal g = t.func_220772_j();
            if (!targetClass.equals(g.getClass()) || t.func_220770_h() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoal)g).field_75307_b)) continue;
            target = g;
            break;
        }
        if (target != null) {
            EntityType type = e.func_200600_R();
            if (typeCheck.test(type)) {
                e.field_70715_bh.func_85156_a(target);
                e.field_70715_bh.func_75776_a(attackPriority, (Goal)replacement.apply(e, nonVampireCheck));
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            LOGGER.warn("Could not replace {} attack target task for {}", (Object)name, (Object)e.func_200600_R().func_212546_e());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof CreatureEntity) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((CreatureEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos(event.getX() - (double)0.4f, event.getY(), event.getZ() - (double)0.4f).func_177977_b();
        if (!event.getWorld().func_175667_e(pos)) {
            return;
        }
        BlockState blockState = event.getWorld().func_180495_p(pos);
        Block b = blockState.func_177230_c();
        boolean deny = false;
        CastleBricksBlock.EnumVariant v = null;
        if (b instanceof CastleBricksBlock) {
            deny = true;
            v = ((CastleBricksBlock)b).getVariant();
        } else if (b instanceof CastleSlabBlock) {
            deny = true;
            v = ((CastleSlabBlock)b).getVariant();
        } else if (b instanceof CastleStairsBlock) {
            deny = true;
            v = ((CastleStairsBlock)b).getVariant();
        }
        if (deny && (v == CastleBricksBlock.EnumVariant.DARK_STONE || event.getEntity().getClassification(false) != VReference.VAMPIRE_CREATURE_TYPE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR && event.getEntity() instanceof PlayerEntity) {
            VampirePlayer.getOpt((PlayerEntity)event.getEntity()).ifPresent(VampirePlayer::requestNaturalArmorUpdate);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d()) {
            IAdjustableLevel entity2;
            if (event.getEntity() instanceof IAdjustableLevel && (entity2 = (IAdjustableLevel)event.getEntity()).getLevel() == -1) {
                Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getWorld(), event.getEntity().func_233580_cy_(), 30);
                int l = entity2.suggestLevel(d);
                if (l > entity2.getMaxLevel()) {
                    l = entity2.getMaxLevel();
                } else if (l < 0) {
                    event.setCanceled(true);
                }
                entity2.setLevel(l);
                if (entity2 instanceof CreatureEntity) {
                    ((CreatureEntity)entity2).func_70606_j(((CreatureEntity)entity2).func_110138_aP());
                }
            }
            if (((Boolean)VampirismConfig.BALANCE.creeperIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof CreeperEntity) {
                ((CreeperEntity)event.getEntity()).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)((CreeperEntity)event.getEntity()), PlayerEntity.class, 20.0f, 1.1, 1.3, Helper::isVampire));
                ModEntityEventHandler.makeVampireFriendly("creeper", (CreeperEntity)event.getEntity(), NearestAttackableTargetGoal.class, PlayerEntity.class, 1, (entity, predicate) -> new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, predicate), type -> type == EntityType.field_200797_k);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.zombieIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof ZombieEntity) {
                ModEntityEventHandler.makeVampireFriendly("zombie", (ZombieEntity)event.getEntity(), NearestAttackableTargetGoal.class, PlayerEntity.class, 2, (entity, predicate) -> entity instanceof DrownedEntity ? new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, predicate.and(arg_0 -> ((DrownedEntity)((DrownedEntity)entity)).func_204714_e(arg_0))) : new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, predicate), type -> type == EntityType.field_200725_aD || type == EntityType.field_200763_C || type == EntityType.field_200727_aF || type == EntityType.field_204724_o);
                ModEntityEventHandler.makeVampireFriendly("villager zombie", (ZombieEntity)event.getEntity(), NearestAttackableTargetGoal.class, AbstractVillagerEntity.class, 3, (entity, predicate) -> new NearestAttackableTargetGoal((MobEntity)entity, AbstractVillagerEntity.class, 10, true, false, predicate), type -> type == EntityType.field_200725_aD || type == EntityType.field_200763_C || type == EntityType.field_200727_aF || type == EntityType.field_204724_o);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.skeletonIgnoreVampire.get()).booleanValue() && (event.getEntity() instanceof SkeletonEntity || event.getEntity() instanceof StrayEntity)) {
                ModEntityEventHandler.makeVampireFriendly("skeleton", (AbstractSkeletonEntity)event.getEntity(), NearestAttackableTargetGoal.class, PlayerEntity.class, 2, (entity, predicate) -> new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, predicate), type -> type == EntityType.field_200741_ag || type == EntityType.field_200750_ap);
            }
            if (event.getEntity() instanceof IronGolemEntity) {
                ((IronGolemEntity)event.getEntity()).field_70715_bh.func_75776_a(4, (Goal)new GolemTargetNonVillageFactionGoal((IronGolemEntity)event.getEntity()));
                Goal mobTarget = null;
                for (PrioritizedGoal t2 : ((IronGolemEntity)event.getEntity()).field_70715_bh.field_220892_d) {
                    if (!(t2.func_220772_j() instanceof NearestAttackableTargetGoal) || t2.func_220770_h() != 3 || !MobEntity.class.equals((Object)((NearestAttackableTargetGoal)t2.func_220772_j()).field_75307_b)) continue;
                    mobTarget = t2.func_220772_j();
                    break;
                }
                if (mobTarget != null) {
                    ((IronGolemEntity)event.getEntity()).field_70715_bh.func_85156_a(mobTarget);
                    ((IronGolemEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((IronGolemEntity)event.getEntity()), MobEntity.class, 5, false, false, entity -> entity instanceof IMob && !(entity instanceof IFactionEntity) && !(entity instanceof CreeperEntity)));
                } else if (this.warnAboutGolem) {
                    LOGGER.warn("Could not replace villager iron golem target task");
                    this.warnAboutGolem = false;
                }
                return;
            }
            if (event.getEntity() instanceof VillagerEntity) {
                Optional<TotemTileEntity> tile = TotemHelper.getTotemNearPos((ServerWorld)event.getWorld(), event.getEntity().func_233580_cy_(), true);
                if (tile.filter(t -> VReference.HUNTER_FACTION.equals(t.getControllingFaction())).isPresent()) {
                    ExtendedCreature.getSafe(event.getEntity()).ifPresent(e -> e.setPoisonousBlood(true));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLootingEvent(LootingLevelEvent event) {
        IItemWithTier.TIER hunterCoatTier;
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof PlayerEntity && ((hunterCoatTier = VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getDamageSource().func_76346_g())).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
            event.setLootingLevel(Math.min(event.getLootingLevel() + 1, 3));
        }
    }

    @SubscribeEvent
    public void onEntityVisibilityCheck(LivingEvent.LivingVisibilityEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && VampirismPlayerAttributes.get(player = (PlayerEntity)event.getEntity()).getHuntSpecial().isDisguised()) {
            event.modifyVisibility((VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getEntity())).getHuntSpecial().fullHunterCoat != null ? 0.5 : 1.0) * (Double)VampirismConfig.BALANCE.haDisguiseVisibilityMod.get());
        }
    }

    @SubscribeEvent
    public void onEyeHeightSet(EntityEvent.Size event) {
        if (event.getEntity() instanceof VampireBaseEntity || event.getEntity() instanceof HunterBaseEntity) {
            event.setNewEyeHeight(event.getOldEyeHeight() * 0.875f);
        }
        if (event.getEntity() instanceof LivingEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof MinionEntity && event.getItem().func_77973_b() instanceof PotionItem) {
            ItemStack stack = event.getResultStack();
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                event.setResultStack(new ItemStack((IItemProvider)Items.field_151069_bo));
                return;
            }
            ((MinionEntity)event.getEntity()).getInventory().ifPresent(inv -> inv.addItemStack(new ItemStack((IItemProvider)Items.field_151069_bo)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getTo().func_77973_b() instanceof VampirismVampireSword) {
            ((VampirismVampireSword)event.getTo().func_77973_b()).updateTrainedCached(event.getTo(), event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof CreatureEntity) {
            event.getEntity().func_130014_f_().func_217381_Z().func_76320_a("vampirism_extended_creature");
            ExtendedCreature.getSafe(event.getEntity()).ifPresent(IExtendedCreatureVampirism::tick);
            event.getEntity().func_130014_f_().func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public void onStartAttackHit(AttackEntityEvent event) {
        if (!Helper.isHunter(event.getPlayer()) && OilUtils.getAppliedOil(event.getPlayer().func_184614_ca()).isPresent()) {
            event.setCanceled(true);
            event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.oils.cannot_use"), true);
        }
    }

    @SubscribeEvent
    public void onActuallyHurt(LivingHurtEvent event) {
        if (event.getSource() instanceof EntityDamageSource && event.getSource().field_76373_n.equals("player") && event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack stack = player.func_184614_ca();
            OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                if (oil instanceof IWeaponOil) {
                    event.setAmount(event.getAmount() + ((IWeaponOil)oil).onHit(stack, event.getAmount(), (IWeaponOil)oil, event.getEntityLiving(), (LivingEntity)player));
                    oil.reduceDuration(stack, (IApplicableOil)oil, oil.getDurationReduction());
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        block2: {
            ItemStack armorStack;
            if (event.getSource() instanceof EntityDamageSource && event.getSource().field_76373_n.equals("player") && event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                ItemStack stack = player.func_184614_ca();
                OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                    if (oil instanceof IWeaponOil) {
                        event.setAmount(event.getAmount() + ((IWeaponOil)oil).onDamage(stack, event.getAmount(), (IWeaponOil)oil, event.getEntityLiving(), (LivingEntity)player));
                    }
                });
            }
            if (!(event.getSource() instanceof EntityDamageSource) || event.getSource().func_76363_c()) break block2;
            Iterator iterator = event.getEntityLiving().func_184193_aE().iterator();
            while (iterator.hasNext() && !OilUtils.getAppliedOil(armorStack = (ItemStack)iterator.next()).map(oil -> {
                if (oil == ModOils.EVASION.get()) {
                    event.setAmount(0.0f);
                    oil.reduceDuration(armorStack, (IApplicableOil)oil, oil.getDurationReduction());
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
            }
        }
    }
}

