/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class SoulOrbEntity
extends Entity
implements IRendersAsItem {
    public static final DataParameter<String> TYPE_PARAMETER = EntityDataManager.func_187226_a(SoulOrbEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private int delayBeforePickup;
    private PlayerEntity player;
    private int age;
    @Nullable
    private ItemStack soulItemStack;

    public SoulOrbEntity(World worldIn, double x, double y, double z, VARIANT type) {
        super((EntityType)ModEntities.SOUL_ORB.get(), worldIn);
        this.setVariant(type);
        this.delayBeforePickup = 10;
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.func_213293_j((this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.field_70146_Z.nextDouble() * 0.2 * 2.0, (this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
    }

    public SoulOrbEntity(EntityType<? extends SoulOrbEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public VARIANT getVariant() {
        return VARIANT.valueOf((String)this.func_184212_Q().func_187225_a(TYPE_PARAMETER));
    }

    private void setVariant(VARIANT type) {
        this.func_184212_Q().func_187227_b(TYPE_PARAMETER, (Object)type.name());
    }

    public ItemStack func_184543_l() {
        return this.getSoulItemStack();
    }

    @Nonnull
    public ItemStack getSoulItemStack() {
        if (this.soulItemStack == null) {
            this.soulItemStack = this.createSoulItemStack();
        }
        return this.soulItemStack;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_98034_c(@Nonnull PlayerEntity player) {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return !Helper.isHunter(player) || player.func_175149_v();
        }
        return true;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.delayBeforePickup == 0 && Helper.isHunter(entityIn) && entityIn.field_71071_by.func_70441_a(this.getSoulItemStack())) {
            entityIn.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        double d1;
        Vector3d vec3d;
        super.func_70071_h_();
        if (this.delayBeforePickup > 0) {
            --this.delayBeforePickup;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
            vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)0.99f, Math.min(vec3d.field_72448_b + (double)5.0E-4f, (double)0.06f), vec3d.field_72449_c * (double)0.99f);
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        if (this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b)) {
            this.func_213293_j((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.field_70170_p.func_226664_a_(this.func_174813_aQ())) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        if (this.age % 10 == 5 & (this.player == null || !this.player.func_70089_S() || this.player.func_70068_e((Entity)this) > 64.0)) {
            this.player = this.field_70170_p.func_190525_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 8.0, EntityPredicates.field_180132_d.and(Helper::isHunter));
        }
        if (this.player != null && (d1 = (vec3d = new Vector3d(this.player.func_226277_ct_() - this.func_226277_ct_(), this.player.func_226278_cu_() + (double)this.player.func_70047_e() / 2.0 - this.func_226278_cu_(), this.player.func_226281_cx_() - this.func_226281_cx_())).func_189985_c()) < 64.0) {
            double d2 = 1.0 - Math.sqrt(d1) / 8.0;
            this.func_213317_d(this.func_213322_ci().func_178787_e(vec3d.func_72432_b().func_186678_a(d2 * d2 * 0.1)));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()));
            BlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, (double)0.98f, (double)f));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, (double)-0.9f, 1.0));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.func_70106_y();
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("type", this.getVariant().name());
        compound.func_74768_a("age", this.age);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TYPE_PARAMETER, (Object)VARIANT.NONE.name());
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setVariant(VARIANT.valueOf(compound.func_74779_i("type")));
        this.age = compound.func_74762_e("age");
        this.soulItemStack = null;
    }

    private ItemStack createSoulItemStack() {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return new ItemStack((IItemProvider)ModItems.SOUL_ORB_VAMPIRE.get());
        }
        return new ItemStack((IItemProvider)ModItems.SOUL_ORB_VAMPIRE.get());
    }

    public static enum VARIANT {
        NONE,
        VAMPIRE;

    }
}

