/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class ThrowableItemEntity
extends ThrowableEntity
implements IRendersAsItem {
    private static final Logger LOGGER = LogManager.getLogger(ThrowableItemEntity.class);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(ThrowableItemEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrowableItemEntity(World worldIn, LivingEntity thrower) {
        super((EntityType)ModEntities.THROWABLE_ITEM.get(), thrower, worldIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack stack = this.func_184543_l();
        if (!stack.func_190926_b()) {
            compound.func_218657_a("thrownItem", (INBT)stack.func_77955_b(new CompoundNBT()));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && !(stack.func_77973_b() instanceof IVampirismThrowableItem)) {
            throw new IllegalArgumentException("EntityThrowable only accepts IVampirismThrowableItem, but not " + stack);
        }
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("thrownItem"));
        if (stack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(stack);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70227_a(RayTraceResult result) {
        ItemStack stack = this.func_184543_l();
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof IVampirismThrowableItem) {
                ((IVampirismThrowableItem)item).onImpact(this, stack, result, this.field_70170_p.field_72995_K);
            } else {
                LOGGER.warn("Saved item ({}) is not an instance of IVampirismThrowableItem. This should not be able to happen", (Object)stack);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public static interface IVampirismThrowableItem {
        public void onImpact(ThrowableItemEntity var1, ItemStack var2, RayTraceResult var3, boolean var4);
    }
}

