/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class FleeGoal
extends Goal {
    private final CreatureEntity theCreature;
    private final double movementSpeed;
    private final World world;
    private final boolean restrictToHome;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public FleeGoal(CreatureEntity theCreature, double movementSpeed, boolean restrictToHome) {
        this.theCreature = theCreature;
        this.movementSpeed = movementSpeed;
        this.restrictToHome = restrictToHome;
        this.world = theCreature.func_130014_f_();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.shouldFlee()) {
            return false;
        }
        Vector3d vec3 = this.findPossibleShelter();
        if (vec3 == null) {
            return false;
        }
        this.shelterX = vec3.field_72450_a;
        this.shelterY = vec3.field_72448_b;
        this.shelterZ = vec3.field_72449_c;
        return true;
    }

    public boolean continueExecuting() {
        return !this.theCreature.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.theCreature.func_70661_as().func_75492_a(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    protected abstract boolean isPositionAcceptable(World var1, BlockPos var2);

    protected abstract boolean shouldFlee();

    private Vector3d findPossibleShelter() {
        Random random = this.theCreature.func_70681_au();
        BlockPos blockpos = new BlockPos(this.theCreature.func_226277_ct_(), this.theCreature.func_174813_aQ().field_72338_b, this.theCreature.func_226281_cx_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.isPositionAcceptable(this.world, blockpos1) || this.restrictToHome && !this.theCreature.func_213384_dI().equals((Object)BlockPos.field_177992_a) && !this.theCreature.func_213389_a(blockpos1)) continue;
            return new Vector3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }
}

