/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AggressiveVillagerEntity
extends VampirismVillagerEntity
implements IHunterMob,
IAggressiveVillager,
IVillageCaptureEntity {
    @Nullable
    private ICaptureAttributes villageAttributes;

    public static AggressiveVillagerEntity makeHunter(@Nonnull VillagerEntity villager) {
        AggressiveVillagerEntity hunter = (AggressiveVillagerEntity)((EntityType)ModEntities.VILLAGER_ANGRY.get()).func_200721_a(villager.field_70170_p);
        assert (hunter != null);
        CompoundNBT nbt = new CompoundNBT();
        if (villager.func_70608_bn()) {
            villager.func_213366_dy();
        }
        villager.func_189511_e(nbt);
        hunter.func_70020_e(nbt);
        hunter.func_184221_a(MathHelper.func_180182_a((Random)hunter.field_70146_Z));
        hunter.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)ModItems.PITCHFORK.get()));
        return hunter;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampirismVillagerEntity.getAttributeBuilder().func_233815_a_(Attributes.field_233818_a_, BalanceMobProps.mobProps.HUNTER_VILLAGER_MAX_HEALTH);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public AggressiveVillagerEntity(EntityType<? extends AggressiveVillagerEntity> type, World worldIn) {
        super(type, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    @Override
    public void attackVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    public void defendVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return false;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null;
    }

    public ILivingEntityData func_213386_a(@Nonnull IServerWorld worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.PITCHFORK.get()));
        return data;
    }

    public void func_213770_a(@Nonnull ServerWorld serverWorldIn) {
    }

    @Override
    public void stopVillageAttackDefense() {
        VillagerEntity villager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_70170_p);
        assert (villager != null);
        this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        CompoundNBT nbt = new CompoundNBT();
        this.func_189511_e(nbt);
        villager.func_70020_e(nbt);
        villager.func_184221_a(MathHelper.func_180182_a((Random)this.field_70146_Z));
        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)villager);
    }

    protected ITextComponent func_225513_by_() {
        return this.func_200600_R().func_212546_e();
    }

    protected void func_213744_a(Brain<VillagerEntity> brainIn) {
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.55, false, 400, () -> true));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(3, new DefendVillageGoal<AggressiveVillagerEntity>(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal<CreatureEntity>((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double func_111175_f() {
                return super.func_111175_f() / 2.0;
            }
        });
    }
}

