/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendAreaGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.FollowLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.MoveToTaskCenterGoal;
import de.teamlapen.vampirism.entity.minion.management.MinionDamageSource;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.container.MinionContainer;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinionEntity<T extends MinionData>
extends VampirismEntity
implements IPlayerOverlay,
ISyncable,
ForceLookEntityGoal.TaskOwner,
IMinionEntity,
IEntityAdditionalSpawnData {
    protected static final DataParameter<Optional<UUID>> LORD_ID = EntityDataManager.func_187226_a(MinionEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();
    private static final int CONVERT_DURATION = 20;
    private final Predicate<LivingEntity> hardAttackPredicate;
    private final Predicate<LivingEntity> softAttackPredicate;
    @Nullable
    protected PlayerMinionController playerMinionController;
    protected T minionData;
    @Nullable
    private Pair<ResourceLocation, Boolean> skinDetails;
    private int minionId;
    private int token;
    private int convertCounter;
    @Nullable
    private PlayerEntity interactingPlayer;

    protected MinionEntity(EntityType<? extends VampirismEntity> type, World world, @Nonnull Predicate<LivingEntity> attackPredicate) {
        super(type, world);
        this.softAttackPredicate = attackPredicate;
        this.hardAttackPredicate = livingEntity -> {
            boolean flag1 = this.getLordOpt().map(ILordPlayer::getPlayer).filter(entity -> entity == livingEntity).isPresent();
            boolean flag2 = livingEntity instanceof MinionEntity && ((MinionEntity)livingEntity).getLordID().filter(id -> this.getLordID().map(id2 -> id == id2).orElse(false)).isPresent();
            return !flag1 && !flag2;
        };
        this.setDontDropEquipment();
        this.peaceful = true;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.isValid()) {
            this.getLordID().ifPresent(id -> nbt.func_186854_a("lord", id));
            nbt.func_74768_a("minion_id", this.minionId);
            nbt.func_74768_a("minion_token", this.token);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.field_70173_aa % 20 == 0) {
                this.consumeOffhand();
            }
        }
        if (this.convertCounter > 0) {
            --this.convertCounter;
        }
        if (!this.field_70170_p.field_72995_K && !this.isValid() && this.func_70089_S()) {
            LOGGER.warn("Minion without lord.");
            this.func_70106_y();
        }
    }

    public void changeMinionName(String name) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).setName(name);
            super.func_200203_b((ITextComponent)((MinionData)this.minionData).getFormattedName());
        }
    }

    public void claimMinionSlot(int id, @Nonnull PlayerMinionController controller) {
        assert (this.minionId == 0);
        controller.claimMinionSlot(id).ifPresent(token -> {
            this.playerMinionController = controller;
            this.minionId = id;
            this.token = token;
            this.func_184212_Q().func_187227_b(LORD_ID, Optional.of(this.playerMinionController.getUUID()));
        });
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (this.playerMinionController != null) {
            this.getLordOpt().map(ILordPlayer::getPlayer).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion.died", new Object[]{this.func_145748_c_()}), true));
            this.playerMinionController.markDeadAndReleaseMinionSlot(this.minionId, this.token);
            this.playerMinionController = null;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a((DamageSource)new MinionDamageSource(this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            ItemStack itemstack = this.func_184614_ca();
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.func_233655_a_(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K && !itemstack.func_190926_b() && entityIn instanceof LivingEntity) {
                itemstack.func_77973_b().func_77644_a(itemstack, (LivingEntity)entityIn, (LivingEntity)this);
                if (itemstack.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    @Nonnull
    public ItemStack func_213357_a(@Nonnull World world, @Nonnull ItemStack stack) {
        if (stack.func_222117_E()) {
            float healAmount = (float)stack.func_77973_b().func_219967_s().func_221466_a() / 2.0f;
            this.func_70691_i(healAmount);
        }
        return super.func_213357_a(world, stack);
    }

    public Predicate<LivingEntity> getAttackPredicate(boolean onlyShould) {
        return onlyShould ? this.hardAttackPredicate.and(this.softAttackPredicate) : this.hardAttackPredicate;
    }

    public abstract List<IMinionTask<?, ?>> getAvailableTasks();

    @Override
    public Optional<IMinionTask.IMinionTaskDesc<?>> getCurrentTask() {
        return this.minionData != null ? Optional.of(((MinionData)this.minionData).getCurrentTaskDesc()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<PlayerEntity> getForceLookTarget() {
        return Optional.ofNullable(this.interactingPlayer);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public Optional<IMinionInventory> getInventory() {
        if (this.minionData != null) {
            return Optional.of(((MinionData)this.minionData).getInventory());
        }
        return Optional.empty();
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryArmor).orElse(EMPTY_LIST);
    }

    @Override
    @Nonnull
    public Optional<ILordPlayer> getLordOpt() {
        return Optional.ofNullable(this.getLord());
    }

    public Optional<T> getMinionData() {
        return Optional.ofNullable(this.minionData);
    }

    @Override
    public Optional<Integer> getMinionId() {
        return this.minionData == null ? Optional.empty() : Optional.of(this.minionId);
    }

    @Override
    public Optional<Pair<ResourceLocation, Boolean>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            this.getLordID().ifPresent(id -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(new GameProfile(id, "Dummy"), p -> {
                this.skinDetails = p;
            })));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public float func_213355_cm() {
        return 0.8f + (float)this.convertCounter / 20.0f * 0.2f;
    }

    @Nonnull
    public EntitySize func_213305_a(@Nonnull Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.func_213355_cm());
    }

    public boolean isTaskLocked() {
        return this.minionData != null && ((MinionData)this.minionData).isTaskLocked();
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryHands).orElse(EMPTY_LIST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadUpdateFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("data_type")) {
            MinionData data = MinionData.fromNBT(nbt);
            try {
                this.minionData = data;
                this.onMinionDataReceived(data);
                this.minionId = nbt.func_74762_e("minion_id");
                super.func_200203_b((ITextComponent)data.getFormattedName());
            }
            catch (ClassCastException e) {
                LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            }
        } else {
            LOGGER.warn("Received empty minion data");
        }
    }

    public void markAsConverted() {
        this.convertCounter = 20;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.checkoutMinionData();
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return this.getInventory().map(IMinionInventory::getInventoryHands).map(i -> (ItemStack)i.get(slotIn.func_188454_b())).orElse(ItemStack.field_190927_a);
            }
            case ARMOR: {
                return this.getInventory().map(IMinionInventory::getInventoryArmor).map(i -> (ItemStack)i.get(slotIn.func_188454_b())).orElse(ItemStack.field_190927_a);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        UUID id;
        super.func_70037_a(nbt);
        UUID uUID = id = nbt.func_186855_b("lord") ? nbt.func_186857_a("lord") : null;
        if (id != null && this.field_70170_p instanceof ServerWorld) {
            this.playerMinionController = MinionWorldData.getData((ServerWorld)this.field_70170_p).getController(id);
            if (this.playerMinionController == null) {
                LOGGER.warn("Cannot get PlayerMinionController for {}", (Object)id);
            } else {
                this.minionId = nbt.func_74762_e("minion_id");
                this.token = nbt.func_74762_e("minion_token");
                this.func_184212_Q().func_187227_b(LORD_ID, Optional.of(id));
            }
        }
    }

    public void onTaskChanged() {
        HelperLib.sync(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.convertCounter = additionalData.func_150792_a();
    }

    @Override
    @Deprecated
    public void recallMinion() {
        this.func_70106_y();
    }

    public void remove(boolean p_remove_1_) {
        super.remove(p_remove_1_);
        if (this.playerMinionController != null) {
            this.playerMinionController.checkInMinion(this.minionId, this.token);
            this.minionData = null;
            this.playerMinionController = null;
        }
    }

    public void func_184201_a(@Nonnull EquipmentSlotType slotIn, @Nonnull ItemStack stack) {
        if (this.minionData == null) {
            return;
        }
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.getInventory().map(IMinionInventory::getInventoryHands).ifPresent(i -> {
                    ItemStack cfr_ignored_0 = (ItemStack)i.set(slotIn.func_188454_b(), (Object)stack);
                });
                break;
            }
            case ARMOR: {
                this.getInventory().map(IMinionInventory::getInventoryArmor).ifPresent(i -> {
                    ItemStack cfr_ignored_0 = (ItemStack)i.set(slotIn.func_188454_b(), (Object)stack);
                });
            }
        }
    }

    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlotType slotType) {
        return itemStack -> !(itemStack.func_77973_b() instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)itemStack.func_77973_b()).getExclusiveFaction().equals(this.getFaction());
    }

    public void func_200203_b(@Nullable ITextComponent name) {
    }

    public void func_70606_j(float health) {
        super.func_70606_j(health);
        if (this.minionData != null) {
            ((MinionData)this.minionData).setHealth(health);
        }
    }

    public void setInteractingPlayer(@Nullable PlayerEntity player) {
        this.interactingPlayer = player;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null || this.hardAttackPredicate.test(entitylivingbaseIn)) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public abstract boolean shouldRenderLordSkin();

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public void writeFullUpdateToNBT(CompoundNBT nbt) {
        if (this.minionData == null && this.field_70170_p.func_73045_a(this.func_145782_y()) != null) {
            this.checkoutMinionData();
        }
        if (this.minionData != null) {
            ((MinionData)this.minionData).serializeNBT(nbt);
            nbt.func_74768_a("minion_id", this.minionId);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.convertCounter);
    }

    protected boolean canConsume(ItemStack stack) {
        if (stack.func_77975_n() != UseAction.DRINK && stack.func_77975_n() != UseAction.EAT) {
            return false;
        }
        return !stack.func_190926_b();
    }

    protected void consumeOffhand() {
        if (this.func_184587_cr()) {
            return;
        }
        if (this.field_70715_bh.func_220888_c().findAny().isPresent()) {
            return;
        }
        ItemStack stack = this.getInventory().map(i -> i.func_70301_a(1)).orElse(ItemStack.field_190927_a);
        if (!this.canConsume(stack)) {
            return;
        }
        this.func_184598_c(Hand.OFF_HAND);
        this.field_70177_z = this.field_70759_as;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LORD_ID, Optional.empty());
    }

    @Nullable
    protected ILordPlayer getLord() {
        return this.getLordID().map(arg_0 -> ((World)this.field_70170_p).func_217371_b(arg_0)).filter(LivingEntity::func_70089_S).flatMap(p -> FactionPlayerHandler.getOpt(p).resolve()).orElse(null);
    }

    protected Optional<UUID> getLordID() {
        return (Optional)this.func_184212_Q().func_187225_a(LORD_ID);
    }

    protected void func_230294_b_(DamageSource damageSource, float damage) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).getInventory().damageArmor(damageSource, damage, this);
        }
    }

    protected boolean isLord(PlayerEntity p) {
        return this.getLordID().map(id -> id.equals(p.func_110124_au())).orElse(false);
    }

    protected boolean isValid() {
        return this.playerMinionController != null;
    }

    protected void onMinionDataReceived(@Nonnull T data) {
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.isLord(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerIn) -> MinionContainer.create(id, playerInventory, this, this.getLord()), (ITextComponent)new TranslationTextComponent("text.vampirism.name").func_230529_a_((ITextComponent)this.getMinionData().map(MinionData::getFormattedName).orElseGet(() -> new StringTextComponent("Minion")))), buf -> buf.func_150787_b(this.func_145782_y()));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, new ForceLookEntityGoal<MinionEntity>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowLordGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new MoveToTaskCenterGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this){

            public boolean func_75250_a() {
                return super.func_75250_a() && !MinionEntity.this.getCurrentTask().filter(t -> t.getTask() == MinionTasks.STAY.get()).isPresent();
            }
        });
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendAreaGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendLordGoal(this));
    }

    private void checkoutMinionData() {
        if (this.playerMinionController != null && this.minionData == null) {
            this.minionData = this.playerMinionController.checkoutMinion(this.minionId, this.token, this);
            if (this.minionData == null) {
                this.playerMinionController = null;
            } else {
                this.handleLoadedMinionData(this.minionData);
            }
        }
    }

    private void handleLoadedMinionData(@Nonnull T data) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)((MinionData)data).getMaxHealth());
        super.func_70606_j(((MinionData)data).getHealth());
        super.func_200203_b((ITextComponent)((MinionData)data).getFormattedName());
        try {
            this.onMinionDataReceived(data);
        }
        catch (ClassCastException e) {
            LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            this.func_70106_y();
        }
    }
}

