/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.CollectResourcesTask;
import de.teamlapen.vampirism.entity.minion.management.DefendAreaTask;
import de.teamlapen.vampirism.entity.minion.management.SimpleMinionTask;
import de.teamlapen.vampirism.entity.minion.management.StayTask;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class MinionTasks {
    public static final DeferredRegister<IMinionTask<?, ?>> MINION_TASKS = DeferredRegister.create(ModRegistries.MINION_TASKS, (String)"vampirism");
    public static final RegistryObject<StayTask> STAY = MINION_TASKS.register("stay", StayTask::new);
    public static final RegistryObject<DefendAreaTask> DEFEND_AREA = MINION_TASKS.register("defend_area", DefendAreaTask::new);
    public static final RegistryObject<SimpleMinionTask> FOLLOW_LORD = MINION_TASKS.register("follow_lord", SimpleMinionTask::new);
    public static final RegistryObject<CollectResourcesTask<HunterMinionEntity.HunterMinionData>> COLLECT_HUNTER_ITEMS = MINION_TASKS.register("collect_hunter_items", () -> new CollectResourcesTask<HunterMinionEntity.HunterMinionData>(VReference.HUNTER_FACTION, data -> (int)((float)((Integer)VampirismConfig.BALANCE.miResourceCooldown.get()).intValue() * (1.0f - (float)(data.getResourceEfficiencyLevel() / 2) * 0.4f)), Arrays.asList(new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)ModItems.GARLIC_BREAD.get()), 10), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)Items.field_191525_da, 19), 25), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)Items.field_151074_bl, 7), 10), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)ModItems.ITEM_GARLIC.get(), 2), 15), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)Items.field_151044_h, 5), 20)), (Supplier<ISkill>)HunterSkills.HUNTER_MINION_COLLECT));
    public static final RegistryObject<CollectResourcesTask<VampireMinionEntity.VampireMinionData>> COLLECT_BLOOD = MINION_TASKS.register("collect_blood", () -> new CollectResourcesTask<VampireMinionEntity.VampireMinionData>(VReference.VAMPIRE_FACTION, data -> (Integer)VampirismConfig.BALANCE.miResourceCooldown.get(), Arrays.asList(new WeightedRandomItem<ItemStack>(BloodBottleItem.getStackWithDamage(9), 20), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)ModItems.HUMAN_HEART.get()), 5), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)Items.field_191525_da, 12), 12), new WeightedRandomItem<ItemStack>(new ItemStack((IItemProvider)Items.field_151074_bl, 6), 10)), (Supplier<ISkill>)VampireSkills.VAMPIRE_MINION_COLLECT));
    public static final RegistryObject<SimpleMinionTask> NOTHING = MINION_TASKS.register("nothing", () -> new SimpleMinionTask(){

        @Override
        public boolean isAvailable(IPlayableFaction<?> faction, @Nullable ILordPlayer player) {
            return false;
        }
    });
    public static final RegistryObject<SimpleMinionTask> PROTECT_LORD = MINION_TASKS.register("protect_lord", SimpleMinionTask::new);

    public static void register(IEventBus bus) {
        MINION_TASKS.register(bus);
    }
}

