/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.BiteNearbyEntityVampireGoal;
import de.teamlapen.vampirism.entity.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.FollowAdvancedVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.goals.MoveToBiteableVampireGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.VampireVillageData;
import de.teamlapen.vampirism.world.MinionWorldData;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BasicVampireEntity
extends VampireBaseEntity
implements IBasicVampire,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(BasicVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final int MAX_LEVEL = 2;
    private final int ANGRY_TICKS_PER_ATTACK = 120;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    private int bloodtimer = 100;
    private IEntityLeader advancedLeader = null;
    private int angryTimer = 0;
    private Goal tasks_avoidHunter;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampireBaseEntity.getAttributeBuilder().func_233815_a_(Attributes.field_233818_a_, 1.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    public BasicVampireEntity(EntityType<? extends BasicVampireEntity> type, World world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getEntityTextureType());
        nbt.func_74757_a("attack", this.attack);
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.field_70173_aa % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.func_70644_a(Effects.field_76426_n)) {
            EffectInstance fireResistance = this.func_184596_c(Effects.field_76426_n);
            assert (fireResistance != null);
            this.func_70688_c(fireResistance);
            this.func_195064_c(new EffectInstance((Effect)ModEffects.FIRE_PROTECTION.get(), fireResistance.func_76459_b(), fireResistance.func_76458_c()));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = false;
    }

    public void convertToMinion(PlayerEntity lord) {
        FactionPlayerHandler.getOpt(lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData(lord.field_70170_p).map(w -> w.getOrCreateController((FactionPlayerHandler)fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(ISkillPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)VampireSkills.VAMPIRE_MINION_STATS_INCREASE.get())).orElse(false);
                            VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData("Minion", this.getEntityTextureType(), false, hasIncreasedStats);
                            int id = controller.createNewMinionSlot(data, (EntityType)ModEntities.VAMPIRE_MINION.get());
                            if (id < 0) {
                                field_184243_a.error("Failed to get minion slot");
                                return;
                            }
                            VampireMinionEntity minion = (VampireMinionEntity)((EntityType)ModEntities.VAMPIRE_MINION.get()).func_200721_a(this.field_70170_p);
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.func_82149_j((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            field_184243_a.warn("Wrong faction for minion");
                        }
                    } else {
                        field_184243_a.warn("No free slot");
                    }
                });
            } else {
                field_184243_a.error("Can't have minions");
            }
        });
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    @Nullable
    public IEntityLeader getAdvancedLeader() {
        return this.advancedLeader;
    }

    public void setAdvancedLeader(@Nullable IEntityLeader advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.func_76346_g(), this);
        }
        super.func_70645_a(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        super.drinkBlood(amt, saturationMod);
        boolean dedicated = ServerLifecycleHooks.getCurrentServer().func_71262_S();
        this.bloodtimer += amt * 40 + this.func_70681_au().nextInt(1000) * (dedicated ? 2 : 1);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if ((reason == SpawnReason.NATURAL || reason == SpawnReason.STRUCTURE) && this.func_70681_au().nextInt(50) == 0) {
            this.func_184201_a(EquipmentSlotType.HEAD, VampireVillageData.createBanner());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public int func_70627_aG() {
        return 2400;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.func_110143_aJ() / this.func_110138_aP();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.func_184212_Q().func_187225_a(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
            if (level == 1) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean flag = super.func_70097_a(damageSource, amount);
        if (flag) {
            this.angryTimer += 120;
        }
        return flag;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
        if (tagCompund.func_74764_b("type")) {
            int t = tagCompund.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.advancedLeader != null && !this.advancedLeader.getRepresentingEntity().func_70089_S()) {
            this.advancedLeader = null;
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public int suggestLevel(de.teamlapen.vampirism.api.difficulty.Difficulty d) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        EffectInstance protection = this.func_70660_b((Effect)ModEffects.FIRE_PROTECTION.get());
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.func_76458_c());
        }
        double d = amount * protectionMod;
        BalanceMobProps.mobProps.getClass();
        return (float)(d * 2.0) * ((float)this.getLevel() * 0.5f + 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get();
    }

    protected int func_70693_a(PlayerEntity player) {
        return 6 + this.getLevel();
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.VAMPIRE_IMOB.get() : (EntityType)ModEntities.VAMPIRE.get();
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70089_S() && !player.func_225608_bj_()) {
            int vampireLevel;
            if (!this.field_70170_p.field_72995_K && (vampireLevel = FactionPlayerHandler.getOpt(player).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0).intValue()) > 0) {
                return FactionPlayerHandler.getOpt(player).map(fph -> {
                    if (fph.getMaxMinions() > 0) {
                        ItemStack heldItem = player.func_184586_b(hand);
                        boolean freeSlot = MinionWorldData.getData(player.field_70170_p).map(data -> data.getOrCreateController((FactionPlayerHandler)fph)).map(controller -> controller.hasFreeMinionSlot()).orElse(false);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.available"), true);
                        if (heldItem.func_77973_b() == ModItems.VAMPIRE_MINION_BINDING.get()) {
                            if (!freeSlot) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.no_free_slot"), true);
                            } else {
                                String key;
                                switch (this.func_70681_au().nextInt(3)) {
                                    case 0: {
                                        key = "text.vampirism.basic_vampire.minion.start_serving1";
                                        break;
                                    }
                                    case 1: {
                                        key = "text.vampirism.basic_vampire.minion.start_serving2";
                                        break;
                                    }
                                    default: {
                                        key = "text.vampirism.basic_vampire.minion.start_serving3";
                                    }
                                }
                                player.func_146105_b((ITextComponent)new TranslationTextComponent(key), false);
                                this.convertToMinion(player);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    heldItem.func_190918_g(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.require_binding", new Object[]{UtilLib.translate(((Item)ModItems.VAMPIRE_MINION_BINDING.get()).func_77658_a(), new Object[0])}), true);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.PASS;
                }).orElse(ActionResultType.PASS);
            }
            return ActionResultType.PASS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == Difficulty.HARD));
        this.tasks_avoidHunter = new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION));
        this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
        this.field_70714_bg.func_75776_a(2, new RestrictSunVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunVampireGoal<BasicVampireEntity>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new BiteNearbyEntityVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowAdvancedVampireGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new MoveToBiteableVampireGoal<BasicVampireEntity>(this, 0.75));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, true, 600, () -> false));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new AttackVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(4, new DefendVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, Structure.field_236381_q_)));
        this.field_70715_bh.func_75776_a(8, (Goal)new DefendLeaderGoal(this));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233818_a_);
        double d = BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION;
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(d + 3.0 * (double)l);
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(Attributes.field_233823_f_);
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)l);
    }

    public static class IMob
    extends BasicVampireEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends BasicVampireEntity> type, World world) {
            super(type, world);
        }
    }
}

