/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.villager;

import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class Trades {
    public static final VillagerTrades.ITrade[] converted_trades = new VillagerTrades.ITrade[]{new VillagerTrades.EmeraldForItemsTrade((IItemProvider)ModItems.HUMAN_HEART.get(), 9, 2, 2), new VillagerTrades.ItemsForEmeraldsTrade((Item)ModItems.HUMAN_HEART.get(), 3, 9, 2), new ItemsForEmeraldsTradeWithDamage(BloodBottleItem.getStackWithDamage(9), 1, 3, 12, 2)};

    public static class Price {
        private final int min;
        private final int max;

        public Price(int minIn, int maxIn) {
            this.max = maxIn;
            this.min = minIn;
        }

        int getPrice(Random rand) {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + rand.nextInt(this.max - this.min);
        }
    }

    public static class VampireForestTrade
    implements VillagerTrades.ITrade {
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;

        public VampireForestTrade(int pEmeraldCost, int pMaxUses, int pVillagerXp) {
            this.emeraldCost = pEmeraldCost;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity pTrader, Random rand) {
            if (pTrader.field_70170_p instanceof ServerWorld) {
                return TotemHelper.getTotemNearPos((ServerWorld)pTrader.field_70170_p, pTrader.func_233580_cy_(), true).flatMap(TotemTileEntity::getVampireForestLocation).map(blockpos -> {
                    ItemStack itemstack = FilledMapItem.func_195952_a((World)pTrader.field_70170_p, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)3, (boolean)true, (boolean)true);
                    FilledMapItem.func_226642_a_((ServerWorld)((ServerWorld)pTrader.field_70170_p), (ItemStack)itemstack);
                    MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
                    itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("biome.vampirism.vampire_forest"));
                    return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCost), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.villagerXp, 0.2f);
                }).orElse(null);
            }
            return null;
        }
    }

    public static class BloodBottleForHeart
    implements VillagerTrades.ITrade {
        private final int xp;
        private final Price price;
        private final Price selling;
        private final int damage;
        private final int maxUses;

        public BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn) {
            this(priceIn, sellingIn, damageIn, 2, 8);
        }

        BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.selling = sellingIn;
            this.damage = damageIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack bottle = new ItemStack((IItemProvider)ModItems.BLOOD_BOTTLE.get(), this.selling.getPrice(random));
            bottle.func_196085_b(this.damage);
            return new MerchantOffer(new ItemStack((IItemProvider)ModItems.HUMAN_HEART.get(), this.price.getPrice(random)), bottle, this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForHeart
    implements VillagerTrades.ITrade {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForHeart(Price priceIn, IItemProvider sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((IItemProvider)sellingItemIn.func_199767_j())}, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, IItemProvider sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((IItemProvider)sellingItemIn.func_199767_j())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return new MerchantOffer(new ItemStack((IItemProvider)ModItems.HUMAN_HEART.get(), this.price.getPrice(random)), new ItemStack((IItemProvider)this.sellingItem[random.nextInt(this.sellingItem.length)].func_77973_b(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForSouls
    implements VillagerTrades.ITrade {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForSouls(Price priceIn, IItemProvider sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((IItemProvider)sellingItemIn.func_199767_j())}, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, IItemProvider sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((IItemProvider)sellingItemIn.func_199767_j())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return new MerchantOffer(new ItemStack((IItemProvider)ModItems.SOUL_ORB_VAMPIRE.get(), this.price.getPrice(random)), new ItemStack((IItemProvider)this.sellingItem[random.nextInt(this.sellingItem.length)].func_77973_b(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForEmeraldsTradeWithDamage
    implements VillagerTrades.ITrade {
        private final ItemStack result;
        private final int emeraldAmount;
        private final int resultAmount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int givenXP) {
            this(new ItemStack((IItemProvider)result), emeraldAmount, resultAmount, 12, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(new ItemStack((IItemProvider)result), emeraldAmount, resultAmount, maxUses, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(result, emeraldAmount, resultAmount, maxUses, givenXP, 0.05f);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP, float priceMultiplier) {
            this.result = result;
            this.emeraldAmount = emeraldAmount;
            this.resultAmount = resultAmount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack second = new ItemStack((IItemProvider)this.result.func_77973_b(), this.resultAmount);
            second.func_196085_b(this.result.func_77952_i());
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldAmount), second, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }
}

