/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.fluids;

import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodHelper {
    private static final Logger LOGGER = LogManager.getLogger(BloodHelper.class);

    public static ItemStack getBloodHandlerInHotbar(PlayerInventory inventory) {
        int hotbarSize = PlayerInventory.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), 1000), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false).booleanValue()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean canStoreBlood(@Nonnull ItemStack stack) {
        return BloodHelper.fill(stack, 1000, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public static ItemStack getGlassBottleInHotbar(PlayerInventory inventory) {
        int hotbarSize = PlayerInventory.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !itemStack.func_77973_b().equals(Items.field_151069_bo)) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getBlood(@Nonnull ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getAmount).orElse(0);
    }

    public static int getBlood(@Nonnull IFluidHandler cap) {
        FluidStack stack = cap.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        return stack.getAmount();
    }

    public static int getBlood(@Nonnull LazyOptional<IFluidHandler> opt) {
        return opt.map(handler -> {
            FluidStack stack = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            return stack.getAmount();
        }).orElse(0);
    }

    public static int drain(@Nonnull ItemStack stack, int amount, IFluidHandler.FluidAction action, boolean exact, Consumer<ItemStack> updateContainer) {
        if (exact && action.execute() && BloodHelper.drain(stack, amount, IFluidHandler.FluidAction.SIMULATE, false, updateContainer) != amount) {
            return 0;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            FluidStack fluidStack = handler.drain(amount, action);
            updateContainer.accept(handler.getContainer());
            return fluidStack.getAmount();
        }).orElse(0);
    }

    public static int fill(@Nonnull ItemStack stack, int amount, IFluidHandler.FluidAction action) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), amount), action)).orElse(0);
    }

    public static int fillBloodIntoInventory(PlayerEntity player, int amt) {
        ItemStack container;
        ItemStack glass;
        if (amt <= 0) {
            return 0;
        }
        ItemStack stack = ItemStack.field_190927_a;
        int hotbarSize = PlayerInventory.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack1 = player.field_71071_by.func_70301_a(i);
            if (stack1.func_190926_b() || BloodHelper.fill(stack1, amt, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            stack = stack1;
            break;
        }
        if (!stack.func_190926_b()) {
            int filled = BloodHelper.fill(stack, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                if (filled < amt) {
                    return BloodHelper.fillBloodIntoInventory(player, amt - filled);
                }
                return 0;
            }
            LOGGER.warn("Could not execute bottle fill even though simulation was successful. Item: {} Amount: {}", (Object)stack, (Object)amt);
        }
        if (!(glass = BloodHelper.getGlassBottleInHotbar(player.field_71071_by)).func_190926_b() && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
            ItemStack bloodBottle = new ItemStack((IItemProvider)ModItems.BLOOD_BOTTLE.get(), 1);
            int filled = BloodHelper.fill(bloodBottle, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                LOGGER.warn("Failed to fill blood bottle with blood");
            }
            glass.func_190918_g(1);
            if (glass.func_190926_b()) {
                player.field_71071_by.func_184437_d(glass);
            }
            if (!player.field_71071_by.func_70441_a(bloodBottle)) {
                player.func_71019_a(bloodBottle, false);
            }
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        if (BloodHelper.hasFeedingAdapterInHotbar(player.field_71071_by) && !(container = BloodHelper.getBloodContainerInInventory(player.field_71071_by, false, true)).func_190926_b()) {
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(container);
            int filled = Math.min(amt, 12600 - content.getAmount());
            content.setAmount(content.getAmount() + filled);
            BloodContainerBlock.writeFluidToItemStack(container, content);
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        return amt;
    }

    public static boolean hasFeedingAdapterInHotbar(PlayerInventory inventory) {
        int hotbarSize = PlayerInventory.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !itemStack.func_77973_b().equals(ModItems.FEEDING_ADAPTER.get())) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getBloodContainerInInventory(PlayerInventory inventory, boolean allowFull, boolean allowEmpty) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(stack);
            if (content.getRawFluid() != ModFluids.BLOOD.get() || !allowFull && content.getAmount() >= 12600 || !allowEmpty && content.getAmount() <= 0) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

