/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import com.google.common.collect.Sets;
import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.network.CTaskActionPacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TaskBoardContainer
extends Container
implements TaskContainer {
    @Nonnull
    private final Set<UUID> completableTasks = Sets.newHashSet();
    @Nonnull
    private final List<ITaskInstance> taskInstances = new ArrayList<ITaskInstance>();
    @Nonnull
    private final TextFormatting factionColor;
    @Nonnull
    private final IFactionPlayer<?> factionPlayer;
    @Nullable
    private Map<UUID, Map<ResourceLocation, Integer>> completedRequirements;
    private UUID taskBoardId;
    @Nullable
    private Runnable listener;

    public TaskBoardContainer(int id, PlayerInventory playerInventory) {
        super((ContainerType)ModContainer.TASK_MASTER.get(), id);
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.field_70458_d).orElseThrow(() -> new IllegalStateException("Can't open container without faction"));
        this.factionColor = this.factionPlayer.getFaction().getChatColor();
    }

    @Override
    public boolean areRequirementsCompleted(@Nonnull ITaskInstance task, @Nonnull TaskRequirement.Type type) {
        if (task.isCompleted()) {
            return true;
        }
        if (this.completableTasks.contains(task.getId())) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey(task.getId())) {
            for (TaskRequirement.Requirement<?> requirement : task.getTask().getRequirement().requirements().get((Object)type)) {
                if (this.completedRequirements.get(task.getId()).containsKey(requirement.getId()) && this.completedRequirements.get(task.getId()).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public TaskContainer.TaskAction buttonAction(@Nonnull ITaskInstance taskInfo) {
        if (this.canCompleteTask(taskInfo)) {
            return TaskContainer.TaskAction.COMPLETE;
        }
        if (this.isTaskNotAccepted(taskInfo)) {
            return TaskContainer.TaskAction.ACCEPT;
        }
        if (!taskInfo.isUnique() && this.factionPlayer.getRepresentingPlayer().field_70170_p.func_82737_E() > taskInfo.getTaskTimeStamp()) {
            return TaskContainer.TaskAction.REMOVE;
        }
        return TaskContainer.TaskAction.ABORT;
    }

    @Override
    public boolean canCompleteTask(@Nonnull ITaskInstance taskInfo) {
        return this.completableTasks.contains(taskInfo.getId()) && (taskInfo.isUnique() || this.factionPlayer.getRepresentingPlayer().field_70170_p.func_82737_E() < taskInfo.getTaskTimeStamp());
    }

    @Override
    public void pressButton(@Nonnull ITaskInstance taskInfo) {
        TaskContainer.TaskAction action = this.buttonAction(taskInfo);
        switch (action) {
            case COMPLETE: {
                taskInfo.complete();
                this.completableTasks.remove(taskInfo.getId());
                this.taskInstances.remove(taskInfo);
                VampLib.proxy.createMasterSoundReference((SoundEvent)ModSounds.TASK_COMPLETE.get(), 1.0f, 1.0f).startPlaying();
                break;
            }
            case ACCEPT: {
                taskInfo.startTask(Minecraft.func_71410_x().field_71441_e.func_82737_E() + taskInfo.getTaskDuration());
                break;
            }
            default: {
                taskInfo.aboardTask();
            }
        }
        VampirismMod.dispatcher.sendToServer(new CTaskActionPacket(taskInfo.getId(), taskInfo.getTaskBoard(), action));
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Nonnull
    public IPlayableFaction<?> getFaction() {
        return this.factionPlayer.getFaction();
    }

    @Override
    @Nonnull
    public TextFormatting getFactionColor() {
        return this.factionColor;
    }

    @Override
    public int getRequirementStatus(@Nonnull ITaskInstance taskInfo, @Nonnull TaskRequirement.Requirement<?> requirement) {
        assert (this.completedRequirements != null);
        if (this.completedRequirements.containsKey(taskInfo.getId())) {
            return this.completedRequirements.get(taskInfo.getId()).get(requirement.getId());
        }
        return requirement.getAmount(this.factionPlayer);
    }

    public ITaskInstance getTask(int i) {
        return this.taskInstances.get(i);
    }

    public UUID getTaskBoardId() {
        return this.taskBoardId;
    }

    @Nonnull
    public List<ITaskInstance> getVisibleTasks() {
        return this.taskInstances;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init(@Nonnull Set<ITaskInstance> available, Set<UUID> completableTasks, Map<UUID, Map<ResourceLocation, Integer>> completedRequirements, UUID taskBoardId) {
        this.taskInstances.clear();
        this.taskInstances.addAll(available);
        this.completableTasks.addAll(completableTasks);
        this.completedRequirements = completedRequirements;
        this.taskBoardId = taskBoardId;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public boolean isCompleted(@Nonnull ITaskInstance item) {
        return item.isCompleted();
    }

    @Override
    public boolean isRequirementCompleted(@Nonnull ITaskInstance taskInfo, @Nonnull TaskRequirement.Requirement<?> requirement) {
        if (taskInfo.isCompleted()) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey(taskInfo.getId())) {
            return this.completedRequirements.get(taskInfo.getId()).containsKey(requirement.getId()) && this.completedRequirements.get(taskInfo.getId()).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer);
        }
        return false;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return VampirismPlayerAttributes.get((PlayerEntity)playerIn).faction != null;
    }

    @Override
    public void setReloadListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    public int size() {
        return this.taskInstances.size();
    }
}

