/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public interface TaskContainer {
    public boolean areRequirementsCompleted(@Nonnull ITaskInstance var1, @Nonnull TaskRequirement.Type var2);

    public TaskAction buttonAction(@Nonnull ITaskInstance var1);

    public boolean canCompleteTask(@Nonnull ITaskInstance var1);

    public TextFormatting getFactionColor();

    public int getRequirementStatus(@Nonnull ITaskInstance var1, @Nonnull TaskRequirement.Requirement<?> var2);

    public boolean isCompleted(@Nonnull ITaskInstance var1);

    public boolean isRequirementCompleted(@Nonnull ITaskInstance var1, @Nonnull TaskRequirement.Requirement<?> var2);

    default public boolean isTaskNotAccepted(@Nonnull ITaskInstance taskInfo) {
        return !taskInfo.isAccepted();
    }

    public void pressButton(@Nonnull ITaskInstance var1);

    public void setReloadListener(@Nullable Runnable var1);

    public static enum TaskAction {
        COMPLETE("gui.vampirism.taskmaster.complete_task"),
        ACCEPT("gui.vampirism.taskmaster.accept_task"),
        ABORT("gui.vampirism.taskmaster.abort_task"),
        REMOVE("gui.vampirism.taskmaster.remove_task");

        @Nonnull
        private final String translationKey;

        private TaskAction(String translationKey) {
            this.translationKey = translationKey;
        }

        @Nonnull
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

