/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlchemicalCauldronRecipe
extends AbstractCookingRecipe {
    private static final ISkill[] EMPTY_SKILLS = new ISkill[0];
    private final Either<Ingredient, FluidStack> fluid;
    @Nonnull
    private final ISkill[] skills;
    private final int reqLevel;

    public AlchemicalCauldronRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, Either<Ingredient, FluidStack> fluidIn, ItemStack resultIn, @Nonnull ISkill[] skillsIn, int reqLevelIn, int cookTimeIn, float exp) {
        super(ModRecipes.ALCHEMICAL_CAULDRON_TYPE, idIn, groupIn, ingredientIn, resultIn, exp, cookTimeIn);
        this.fluid = fluidIn;
        this.skills = skillsIn;
        this.reqLevel = reqLevelIn;
    }

    public boolean canBeCooked(int level, ISkillHandler<IHunterPlayer> skillHandler) {
        if (level < this.reqLevel) {
            return false;
        }
        for (ISkill s : this.skills) {
            if (skillHandler.isSkillEnabled(s)) continue;
            return false;
        }
        return true;
    }

    public Either<Ingredient, FluidStack> getFluid() {
        return this.fluid;
    }

    public int getRequiredLevel() {
        return this.reqLevel;
    }

    @Nonnull
    public ISkill[] getRequiredSkills() {
        return this.skills;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.ALCHEMICAL_CAULDRON.get();
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        boolean match = this.field_222142_d.test(inv.func_70301_a(1));
        AtomicBoolean fluidMatch = new AtomicBoolean(true);
        this.fluid.ifLeft(ingredient1 -> fluidMatch.set(ingredient1.test(inv.func_70301_a(0))));
        this.fluid.ifRight(ingredient1 -> {
            fluidMatch.set(false);
            Optional stack = FluidUtil.getFluidContained((ItemStack)inv.func_70301_a(0));
            stack.ifPresent(handlerItem -> fluidMatch.set(ingredient1.isFluidEqual(handlerItem) && ingredient1.getAmount() <= handlerItem.getAmount()));
        });
        return match && fluidMatch.get();
    }

    public String toString() {
        return "AlchemicalCauldronRecipe{cookingTime=" + this.field_222145_g + ", skills=" + Arrays.toString(this.skills) + ", output=" + this.field_222143_e + ", ingredient=" + this.field_222142_d + ", reqLevel=" + this.reqLevel + ", experience=" + this.field_222144_f + ", fluid=" + this.fluid + '}';
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlchemicalCauldronRecipe> {
        public AlchemicalCauldronRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredients = Ingredient.func_199802_a((JsonElement)(JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient")));
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            ISkill[] skills = VampirismRecipeHelper.deserializeSkills(JSONUtils.func_151213_a((JsonObject)json, (String)"skill", null));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            Either<Ingredient, FluidStack> fluid = VampirismRecipeHelper.getFluidOrItem(json);
            int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookTime", (int)200);
            float exp = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.2f);
            return new AlchemicalCauldronRecipe(recipeId, group, ingredients, fluid, result, skills, level, cookTime, exp);
        }

        public AlchemicalCauldronRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            ItemStack result = buffer.func_150791_c();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Either fluid = buffer.readBoolean() ? Either.left((Object)Ingredient.func_199566_b((PacketBuffer)buffer)) : Either.right((Object)FluidStack.readFromPacket((PacketBuffer)buffer));
            float exp = buffer.readFloat();
            int cookingtime = buffer.func_150792_a();
            int level = buffer.func_150792_a();
            ISkill[] skills = new ISkill[buffer.func_150792_a()];
            for (int i = 0; i < skills.length; ++i) {
                skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            }
            return new AlchemicalCauldronRecipe(recipeId, group, ingredient, (Either<Ingredient, FluidStack>)fluid, result, skills, level, cookingtime, exp);
        }

        public void toNetwork(PacketBuffer buffer, AlchemicalCauldronRecipe recipe) {
            buffer.func_180714_a(recipe.field_222141_c);
            buffer.func_150788_a(recipe.field_222143_e);
            recipe.field_222142_d.func_199564_a(buffer);
            if (recipe.fluid.left().isPresent()) {
                buffer.writeBoolean(true);
                ((Ingredient)recipe.fluid.left().get()).func_199564_a(buffer);
            } else {
                assert (recipe.fluid.right().isPresent());
                buffer.writeBoolean(false);
                ((FluidStack)recipe.fluid.right().get()).writeToPacket(buffer);
            }
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
            buffer.func_150787_b(recipe.reqLevel);
            buffer.func_150787_b(recipe.skills.length);
            for (ISkill skill : recipe.skills) {
                buffer.func_180714_a(skill.getRegistryName().toString());
            }
        }
    }
}

