/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ThrowablePotionItem;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import org.apache.commons.lang3.tuple.Triple;

public class ExtendedBrewingRecipeRegistry
implements IExtendedBrewingRecipeRegistry {
    private final List<ExtendedPotionMix> conversionMixes = new ArrayList<ExtendedPotionMix>();

    @Override
    public void addMix(ExtendedPotionMix potionMix) {
        this.conversionMixes.add(potionMix);
    }

    @Override
    public void addMix(ExtendedPotionMix[] mixPredicate) {
        this.conversionMixes.addAll(Arrays.asList(mixPredicate));
    }

    @Override
    public boolean brewPotions(NonNullList<ItemStack> inputs, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int[] inputIndexes, boolean onlyExtended) {
        boolean brewed = false;
        int useMain = 0;
        int useExtra = 0;
        for (int i : inputIndexes) {
            Optional<Triple<ItemStack, Integer, Integer>> output = this.getOutput((ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities, onlyExtended);
            if (!output.isPresent()) continue;
            Triple<ItemStack, Integer, Integer> triple = output.get();
            inputs.set(i, triple.getLeft());
            useMain = Math.max(useMain, (Integer)triple.getMiddle());
            useExtra = Math.max(useExtra, (Integer)triple.getRight());
            brewed = true;
        }
        ingredient.func_190918_g(useMain);
        extraIngredient.func_190918_g(useExtra);
        return brewed;
    }

    @Override
    public boolean canBrew(NonNullList<ItemStack> inputs, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int[] inputIndexes) {
        if (ingredient.func_190926_b()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!this.hasOutput((ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Triple<ItemStack, Integer, Integer>> getOutput(ItemStack bottle, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, boolean onlyExtended) {
        if (bottle.func_190926_b() || bottle.func_190916_E() != 1) {
            return Optional.empty();
        }
        if (ingredient.func_190926_b()) {
            return Optional.empty();
        }
        Potion potion = PotionUtils.func_185191_c((ItemStack)bottle);
        if (bottle.func_77973_b() instanceof ThrowablePotionItem && potion.func_185170_a().stream().anyMatch(a -> a.func_188419_a().func_220303_e() == EffectType.BENEFICIAL)) {
            return Optional.empty();
        }
        Item item = bottle.func_77973_b();
        ArrayList<ExtendedPotionMix> possibleResults = new ArrayList<ExtendedPotionMix>();
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (mix.input.get() != potion || !mix.reagent1.filter(i -> i.test(ingredient)).isPresent() || ingredient.func_190916_E() < mix.reagent1Count || mix.reagent2Count > 0 && (!mix.reagent2.filter(i -> i.test(extraIngredient)).isPresent() || extraIngredient.func_190916_E() < mix.reagent2Count) || !mix.canBrew(capabilities)) continue;
            possibleResults.add(mix);
        }
        if (!possibleResults.isEmpty()) {
            possibleResults.sort((mix1, mix2) -> mix1.efficient ? (mix2.efficient ? 0 : -1) : (mix2.efficient ? 1 : 0));
            ExtendedPotionMix mix = (ExtendedPotionMix)possibleResults.get(0);
            return Optional.of(Triple.of((Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)item), (Potion)((Potion)mix.output.get())), (Object)mix.reagent1Count, (Object)mix.reagent2Count));
        }
        ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)bottle, (ItemStack)ingredient);
        return output.func_190926_b() ? Optional.empty() : Optional.of(Triple.of((Object)output, (Object)1, (Object)0));
    }

    @Override
    public List<ExtendedPotionMix> getPotionMixes() {
        return Collections.unmodifiableList(this.conversionMixes);
    }

    @Override
    public boolean hasOutput(ItemStack input, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities) {
        return this.getOutput(input, ingredient, extraIngredient, capabilities, false).isPresent();
    }

    @Override
    public boolean isValidExtraIngredient(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent2.filter(i -> i.test(stack)).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidIngredient(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent1.filter(i -> i.test(stack)).isPresent()) continue;
            return true;
        }
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }

    @Override
    public boolean isValidInput(ItemStack stack) {
        if (stack.func_190916_E() != 1) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI || item == Items.field_151069_bo || BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }
}

