/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BlessableItem
extends Item {
    private final Supplier<Item> blessedItem;
    @Nullable
    private final Supplier<Item> enhancedBlessedItem;
    private static final List<BlessableItem> BLESSABLE_ITEMS = new ArrayList<BlessableItem>();

    public static List<Recipe> getBlessableRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (BlessableItem i : BLESSABLE_ITEMS) {
            recipes.add(new Recipe(false, i, i.blessedItem.get()));
            if (i.enhancedBlessedItem == null) continue;
            recipes.add(new Recipe(true, i, i.enhancedBlessedItem.get()));
        }
        return recipes;
    }

    public BlessableItem(Item.Properties properties, Supplier<Item> blessedItem, @Nullable Supplier<Item> enhancedBlessedItem) {
        super(properties.func_200916_a(VampirismMod.creativeTab));
        this.blessedItem = blessedItem;
        this.enhancedBlessedItem = enhancedBlessedItem;
        BLESSABLE_ITEMS.add(this);
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 316;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == ModBlocks.CHURCH_ALTAR.get()) {
            if (!Helper.isHunter(context.func_195999_j())) {
                return ActionResultType.PASS;
            }
            context.func_195999_j().func_184598_c(context.func_221531_n());
            context.func_195999_j().func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 2));
            context.func_195999_j().func_195064_c(new EffectInstance(Effects.field_76440_q, 40, 2));
            return ActionResultType.CONSUME;
        }
        return super.func_195939_a(context);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int ticksLeft) {
        if (ticksLeft == 300 && player.field_70170_p.func_201670_d() && player instanceof PlayerEntity) {
            HunterPlayer.getOpt((PlayerEntity)player).map(HunterPlayer::getSpecialAttributes).ifPresent(att -> {
                if (att.blessingSoundReference != null) {
                    att.blessingSoundReference.stopPlaying();
                }
                att.blessingSoundReference = VampLib.proxy.createSoundReference((SoundEvent)ModSounds.BLESSING_MUSIC.get(), SoundCategory.PLAYERS, player.func_233580_cy_(), 1.0f, 1.0f);
                att.blessingSoundReference.startPlaying();
            });
        }
        if (ticksLeft % 20 == 1) {
            Vector3d mainPos = UtilLib.getItemPosition(player, player.func_184600_cs() == Hand.MAIN_HAND);
            for (int j = 0; j < 3; ++j) {
                Vector3d pos = mainPos.func_72441_c((double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f), (double)((player.func_70681_au().nextFloat() - 0.3f) * 0.9f), (double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f));
                UtilLib.spawnParticles(player.field_70170_p, (IParticleData)ParticleTypes.field_197623_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, 10, 0.4f);
            }
            if (ticksLeft > 21) {
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 2));
                player.func_195064_c(new EffectInstance(Effects.field_76440_q, 40, 2));
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity livingEntity) {
        if (this.enhancedBlessedItem != null && livingEntity instanceof PlayerEntity) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)livingEntity);
            boolean enhanced = handler.isInFaction(VReference.HUNTER_FACTION) && handler.getCurrentFactionPlayer().map(ISkillPlayer::getSkillHandler).map(s -> s.isSkillEnabled((ISkill)HunterSkills.ENHANCED_BLESSING.get())).orElse(false) != false;
            return new ItemStack(enhanced ? (IItemProvider)this.enhancedBlessedItem.get() : (IItemProvider)this.blessedItem.get(), stack.func_190916_E());
        }
        return new ItemStack((IItemProvider)this.blessedItem.get(), stack.func_190916_E());
    }

    public void func_77615_a(ItemStack sttack, World world, LivingEntity player, int duration) {
        if (player.field_70170_p.func_201670_d() && player instanceof PlayerEntity) {
            HunterPlayer.getOpt((PlayerEntity)player).map(HunterPlayer::getSpecialAttributes).ifPresent(att -> {
                if (att.blessingSoundReference != null) {
                    att.blessingSoundReference.stopPlaying();
                }
            });
        }
    }

    public Item getBlessedItem() {
        return this.blessedItem.get();
    }

    public static class Recipe {
        public final boolean enhanced;
        public final BlessableItem input;
        public final Item output;

        public Recipe(boolean enhanced, BlessableItem input, Item output) {
            this.enhanced = enhanced;
            this.input = input;
            this.output = output;
        }
    }
}

