/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BloodBottleItem
extends Item
implements IFactionExclusiveItem {
    public static final int AMOUNT = 9;
    private static final int MULTIPLIER = 100;
    private static final int capacity = 900;

    public static ItemStack getStackWithDamage(int damage) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.BLOOD_BOTTLE.get());
        stack.func_196085_b(damage);
        return stack;
    }

    public BloodBottleItem() {
        super(new Item.Properties().func_200915_b(9).func_200916_a(VampirismMod.creativeTab).setNoRepair());
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        TileEntity t = world.func_175625_s(pos);
        return t != null && t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).isPresent();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> list) {
        super.func_150895_a(group, list);
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.BLOOD_BOTTLE.get());
            stack.func_196085_b(9);
            list.add((Object)stack);
        }
    }

    @Override
    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull LivingEntity entityLiving) {
        if (entityLiving instanceof IVampire) {
            int blood = BloodHelper.getBlood(stack);
            int drink = Math.min(blood, 100);
            ItemStack[] result = new ItemStack[1];
            int amt = BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> {
                result[0] = containerStack;
            });
            ((IVampire)entityLiving).drinkBlood(amt / 100, 0.0f, false);
            return result[0];
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(IFluidHandlerItem::getContainer).orElseGet(() -> super.func_77654_b(stack, worldIn, entityLiving));
    }

    public int func_77626_a(ItemStack stack) {
        return 15;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new BloodBottleFluidHandler(stack, 900);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof IVampire) {
            return;
        }
        if (!(player instanceof PlayerEntity) || !player.func_70089_S()) {
            player.func_184597_cx();
            return;
        }
        int blood = BloodHelper.getBlood(stack);
        VampirePlayer vampire = VampirePlayer.getOpt((PlayerEntity)player).resolve().orElse(null);
        if (vampire == null || vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            player.func_184597_cx();
            return;
        }
        if (blood > 0 && count == 1) {
            Hand activeHand = player.func_184600_cs();
            int drink = Math.min(blood, 300);
            if (BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> player.func_184611_a(activeHand, containerStack)) > 0) {
                vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.3f, false);
            }
            if ((blood = BloodHelper.getBlood(stack)) > 0) {
                player.func_184598_c(player.func_184600_cs());
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            if (vampire.getBloodStats().needsBlood() && stack.func_190916_E() == 1) {
                playerIn.func_184598_c(handIn);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }).orElse(new ActionResult(ActionResultType.PASS, (Object)stack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

