/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.client.model.armor.CloakModel;
import de.teamlapen.vampirism.items.VampireClothingItem;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColoredVampireClothingItem
extends VampireClothingItem {
    private final String baseName;
    private final EnumClothingColor color;
    private final EnumModel model;

    public ColoredVampireClothingItem(EquipmentSlotType slotType, EnumModel model, String baseRegName, EnumClothingColor color) {
        super(slotType);
        this.baseName = baseRegName;
        this.color = color;
        this.model = model;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        switch (this.model) {
            case CLOAK: {
                return CloakModel.getRotatedCloak();
            }
        }
        return CloakModel.getRotatedCloak();
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("vampirism:textures/models/armor/%s/%s_%s.png", this.baseName, this.baseName, this.color.getName());
    }

    public static enum EnumClothingColor implements IStringSerializable
    {
        REDBLACK("red_black"),
        BLACKRED("black_red"),
        BLACKWHITE("black_white"),
        WHITEBLACK("white_black"),
        BLACKBLUE("black_blue");

        private final String name;

        private EnumClothingColor(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumModel {
        CLOAK;

    }
}

