/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.blocks.AlchemicalFireBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrossbowArrowItem
extends ArrowItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private final EnumArrowType type;

    public CrossbowArrowItem(EnumArrowType type) {
        super(new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag tooltipFlag) {
        switch (this.type) {
            case SPITFIRE: {
                textComponents.add((ITextComponent)new TranslationTextComponent("item.vampirism.crossbow_arrow_spitfire.tooltip").func_240699_a_(TextFormatting.GRAY));
                break;
            }
            case VAMPIRE_KILLER: {
                textComponents.add((ITextComponent)new TranslationTextComponent("item.vampirism.crossbow_arrow_vampire_killer.tooltip").func_240699_a_(TextFormatting.GRAY));
                break;
            }
            case TELEPORT: {
                textComponents.add((ITextComponent)new TranslationTextComponent("item.vampirism.crossbow_arrow_teleport.tooltip").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    @Override
    @Deprecated
    public CrossbowArrowEntity createEntity(ItemStack stack, World world, PlayerEntity player, double heightOffset, double centerOffset, boolean rightHand) {
        CrossbowArrowEntity entity = CrossbowArrowEntity.createWithShooter(world, (LivingEntity)player, heightOffset, centerOffset, rightHand, stack);
        entity.func_70239_b(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            entity.func_70015_d(100);
        }
        return entity;
    }

    @Nonnull
    public AbstractArrowEntity func_200887_a(@Nonnull World level, @Nonnull ItemStack stack, @Nonnull LivingEntity entity) {
        CrossbowArrowEntity arrowEntity = new CrossbowArrowEntity(level, entity, stack);
        arrowEntity.setEffectsFromItem(stack);
        arrowEntity.func_70239_b(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            arrowEntity.func_70015_d(100);
        }
        arrowEntity.field_70251_a = this.type == EnumArrowType.NORMAL ? AbstractArrowEntity.PickupStatus.ALLOWED : AbstractArrowEntity.PickupStatus.DISALLOWED;
        return arrowEntity;
    }

    public EnumArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isCanBeInfinite() {
        return this.type == EnumArrowType.NORMAL || (Boolean)VampirismConfig.BALANCE.allowInfiniteSpecialArrows.get() != false;
    }

    @Override
    public void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        CrossbowArrowEntity entity = (CrossbowArrowEntity)arrowEntity;
        switch (this.type) {
            case SPITFIRE: {
                for (int dx = -1; dx < 2; ++dx) {
                    for (int dy = -2; dy < 2; ++dy) {
                        for (int dz = -1; dz < 2; ++dz) {
                            BlockPos pos = blockPos.func_177982_a(dx, dy, dz);
                            BlockState blockState = entity.func_130014_f_().func_180495_p(pos);
                            if (!blockState.func_185904_a().func_76222_j() || !entity.func_130014_f_().func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)entity.func_130014_f_(), pos.func_177977_b(), Direction.UP) || entity.getRNG().nextInt(4) == 0) continue;
                            entity.func_130014_f_().func_175656_a(pos, ((AlchemicalFireBlock)ModBlocks.ALCHEMICAL_FIRE.get()).func_176223_P());
                        }
                    }
                }
                break;
            }
            case TELEPORT: {
                if (shootingEntity.field_70170_p.field_72995_K || !shootingEntity.func_70089_S()) break;
                if (shootingEntity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)shootingEntity;
                    if (!player.field_71135_a.func_147298_b().func_150724_d() || player.field_70170_p != entity.field_70170_p || player.func_70608_bn()) break;
                    if (player.func_184218_aH()) {
                        player.func_184210_p();
                    }
                    player.func_70634_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
                    player.field_70143_R = 0.0f;
                    player.func_70097_a(DamageSource.field_76379_h, 1.0f);
                    break;
                }
                if (shootingEntity == null) break;
                shootingEntity.func_70634_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
                shootingEntity.field_70143_R = 0.0f;
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        if (this.type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.func_110138_aP()) < (float)((Integer)VampirismConfig.BALANCE.arrowVampireKillerMaxHealth.get()).intValue()) {
            entity.func_70097_a(DamageSource.func_76353_a((AbstractArrowEntity)((AbstractArrowEntity)arrowEntity), (Entity)shootingEntity), max);
        }
    }

    public static enum EnumArrowType implements IStringSerializable
    {
        NORMAL("normal", 2.0, 0xFFFFFF),
        VAMPIRE_KILLER("vampire_killer", 0.5, 7995507),
        SPITFIRE("spitfire", 0.5, 0xFF2211),
        TELEPORT("teleport", 0.5, 740674);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }

        public String getName() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

