/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrucifixItem
extends Item
implements IItemWithTier,
IFactionExclusiveItem,
IFactionLevelItem<IHunterPlayer> {
    private final IItemWithTier.TIER tier;
    private static final Set<CrucifixItem> all_crucifix = Collections.synchronizedSet(new HashSet());

    public CrucifixItem(IItemWithTier.TIER tier) {
        super(new Item.Properties().func_200916_a(VampirismMod.creativeTab).func_200917_a(1));
        this.tier = tier;
        all_crucifix.add(this);
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 1;
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        if (this.tier == IItemWithTier.TIER.ULTIMATE) {
            return (ISkill)HunterSkills.ULTIMATE_CRUCIFIX.get();
        }
        return (ISkill)HunterSkills.CRUCIFIX_WIELDER.get();
    }

    @Override
    @Nullable
    public IPlayableFaction<IHunterPlayer> getUsingFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.HUNTER_FACTION;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        this.addFactionExclusiveToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (held && entity instanceof LivingEntity && entity.field_70173_aa % 16 == 8 && Helper.isVampire(entity)) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), 20, 1));
        }
    }

    protected boolean affectsEntity(LivingEntity e) {
        return e.func_70668_bt() == CreatureAttribute.field_223223_b_ || Helper.isVampire((Entity)e);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof PlayerEntity) {
            all_crucifix.forEach(item -> ((PlayerEntity)entity).func_184811_cZ().func_185145_a((Item)item, this.getCooldown(stack)));
        }
    }

    protected int getCooldown(ItemStack stack) {
        switch (this.tier) {
            case ENHANCED: {
                return 100;
            }
            case ULTIMATE: {
                return 60;
            }
        }
        return 140;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    protected static int determineEntityTier(LivingEntity e) {
        if (e instanceof PlayerEntity) {
            int level = VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)e)).vampireLevel;
            int tier = 1;
            if (level == VReference.VAMPIRE_FACTION.getHighestReachableLevel()) {
                tier = 3;
            } else if (level >= 8) {
                tier = 2;
            }
            if (VampirePlayer.getOpt((PlayerEntity)e).map(VampirePlayer::getSkillHandler).map(h -> h.isRefinementEquipped((IRefinement)ModRefinements.CRUCIFIX_RESISTANT.get())).orElse(false).booleanValue()) {
                ++tier;
            }
            return tier;
        }
        if (e instanceof VampireBaronEntity) {
            return 3;
        }
        if (e instanceof AdvancedVampireEntity) {
            return 2;
        }
        return 1;
    }

    protected double determineSlowdown(int entityTier) {
        switch (this.tier) {
            case NORMAL: {
                return entityTier > 1 ? 0.1 : 0.5;
            }
            case ENHANCED: {
                return entityTier > 2 ? 0.1 : 0.5;
            }
            case ULTIMATE: {
                return entityTier > 3 ? 0.3 : 0.5;
            }
        }
        return 0.0;
    }

    protected int getRange(ItemStack stack) {
        switch (this.tier) {
            case ENHANCED: {
                return 8;
            }
            case ULTIMATE: {
                return 10;
            }
        }
        return 4;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        for (LivingEntity nearbyEntity : player.field_70170_p.func_217374_a(LivingEntity.class, new EntityPredicate().func_221012_a(this::affectsEntity), player, player.func_174813_aQ().func_186662_g((double)this.getRange(stack)))) {
            double scale;
            Vector3d oldDelta;
            Vector3d horizontalDelta;
            Vector3d baseVector = player.func_213303_ch().func_178788_d(nearbyEntity.func_213303_ch()).func_216372_d(1.0, 0.0, 1.0).func_72432_b();
            double parallelScale = baseVector.func_72430_b(horizontalDelta = (oldDelta = nearbyEntity.func_213322_ci()).func_216372_d(1.0, 0.0, 1.0));
            if (!(parallelScale > 0.0)) continue;
            Vector3d parallelPart = baseVector.func_186678_a(parallelScale);
            Vector3d newDelta = oldDelta.func_178788_d(parallelPart.func_186678_a(scale = this.determineSlowdown(CrucifixItem.determineEntityTier(nearbyEntity))));
            if (newDelta.func_189985_c() > oldDelta.func_189985_c()) {
                newDelta = Vector3d.field_186680_a;
            }
            Vector3d collisionDelta = nearbyEntity.func_213306_e(newDelta);
            if (collisionDelta.field_72448_b != newDelta.field_72448_b && newDelta.field_72448_b < 0.0) {
                newDelta = newDelta.func_216372_d(1.0, 0.0, 1.0);
            }
            nearbyEntity.func_213317_d(newDelta);
        }
    }
}

