/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeartSeekerItem
extends VampirismVampireSword
implements IItemWithTier {
    private static final int[] DAMAGE_TIER = new int[]{7, 8, 9};
    private static final float[] UNTRAINED_SPEED_TIER = new float[]{-3.6f, -3.5f, -3.4f};
    private static final float[] TRAINED_SPEED_TIER = new float[]{-2.2f, -2.1f, -2.0f};
    private final IItemWithTier.TIER tier;

    public HeartSeekerItem(IItemWithTier.TIER tier) {
        super(ItemTier.IRON, DAMAGE_TIER[tier.ordinal()], UNTRAINED_SPEED_TIER[tier.ordinal()], TRAINED_SPEED_TIER[tier.ordinal()], new Item.Properties().func_200916_a(VampirismMod.creativeTab).func_200918_c(2500));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return (this.getVampirismTier() == IItemWithTier.TIER.NORMAL ? (Item)ModItems.BLOOD_INFUSED_IRON_INGOT.get() : (Item)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()).equals(repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.getVampirismTier() == IItemWithTier.TIER.ULTIMATE ? super.getXpRepairRatio(stack) / 2.0f : super.getXpRepairRatio(stack);
    }

    @Override
    protected float getChargeUsage() {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordBloodUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }
}

