/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterWeapon;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterAxeItem
extends VampirismHunterWeapon
implements IItemWithTier {
    private final IItemWithTier.TIER tier;

    public HunterAxeItem(IItemWithTier.TIER tier) {
        super((IItemTier)ItemTier.IRON, 10, -2.9f, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.deals_more_damage_to", new Object[]{Math.round((this.getVampireMult() - 1.0f) * 100.0f), VReference.VAMPIRE_FACTION.getNamePlural()}).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.getEnchantedStack());
        }
    }

    @Override
    public float getDamageMultiplierForFaction(@Nonnull ItemStack stack) {
        return this.getVampireMult();
    }

    public ItemStack getEnchantedStack() {
        ItemStack stack = new ItemStack((IItemProvider)this);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(Enchantments.field_180313_o, this.getKnockback());
        EnchantmentHelper.func_82782_a(map, (ItemStack)stack);
        return stack;
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return this.getMinLevel();
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    private int getKnockback() {
        switch (this.tier) {
            case ULTIMATE: {
                return 4;
            }
            case ENHANCED: {
                return 3;
            }
        }
        return 2;
    }

    private int getMinLevel() {
        switch (this.tier) {
            case ULTIMATE: {
                return 8;
            }
            case ENHANCED: {
                return 6;
            }
        }
        return 4;
    }

    private float getVampireMult() {
        switch (this.tier) {
            case ULTIMATE: 
            case ENHANCED: {
                return 1.3f;
            }
        }
        return 1.2f;
    }
}

