/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterIntelItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int level;
    private ITextComponent tooltip;
    private String descriptionId;

    public static HunterIntelItem getIntelForExactlyLevel(int level) {
        return HunterIntelItem.getIntelForLevel(level - 5);
    }

    public static HunterIntelItem getIntelForLevel(int level) {
        switch (level) {
            case 0: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_0.get();
            }
            case 1: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_1.get();
            }
            case 2: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_2.get();
            }
            case 3: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_3.get();
            }
            case 4: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_4.get();
            }
            case 5: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_5.get();
            }
            case 6: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_6.get();
            }
            case 7: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_7.get();
            }
            case 8: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_8.get();
            }
            case 9: {
                return (HunterIntelItem)ModItems.HUNTER_INTEL_9.get();
            }
        }
        LOGGER.warn("HunterIntel of level {} does not exist", (Object)level);
        return (HunterIntelItem)ModItems.HUNTER_INTEL_9.get();
    }

    public HunterIntelItem(int level) {
        super(new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.level = level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltips, ITooltipFlag flagIn) {
        if (this.tooltip == null) {
            this.tooltip = new TranslationTextComponent("text.vampirism.for_up_to_level").func_230529_a_((ITextComponent)new StringTextComponent(": " + (this.level + 5))).func_240699_a_(TextFormatting.RED);
        }
        tooltips.add(this.tooltip);
    }

    public ITextComponent getCustomName() {
        return new TranslationTextComponent(this.func_195935_o()).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.for_up_to_level").func_230529_a_((ITextComponent)new StringTextComponent(" " + (this.level + 5))));
    }

    public int getLevel() {
        return this.level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    protected String func_195935_o() {
        if (this.descriptionId == null) {
            this.descriptionId = super.func_195935_o().replaceAll("_\\d", "");
        }
        return this.descriptionId;
    }
}

