/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.client.model.armor.ClothingBootsModel;
import de.teamlapen.vampirism.client.model.armor.ClothingCrownModel;
import de.teamlapen.vampirism.client.model.armor.ClothingPantsModel;
import de.teamlapen.vampirism.client.model.armor.DummyClothingModel;
import de.teamlapen.vampirism.client.model.armor.VampireHatModel;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismArmorMaterials;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireClothingItem
extends ArmorItem
implements IFactionExclusiveItem {
    public VampireClothingItem(EquipmentSlotType slotType) {
        super((IArmorMaterial)VampirismArmorMaterials.VAMPIRE_CLOTH, slotType, new Item.Properties().func_200915_b(ArmorMaterial.IRON.func_200896_a(slotType)).func_200916_a(VampirismMod.creativeTab));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addFactionExclusiveToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        switch (this.getRegistryName().func_110623_a()) {
            case "vampire_clothing_crown": {
                return ClothingCrownModel.getInstance();
            }
            case "vampire_clothing_legs": {
                return ClothingPantsModel.getInstance();
            }
            case "vampire_clothing_boots": {
                return ClothingBootsModel.getInstance();
            }
            case "vampire_clothing_hat": {
                return VampireHatModel.getInstance();
            }
        }
        return DummyClothingModel.getArmorModel();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("vampirism:textures/models/armor/%s.png", this.getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (player.field_70173_aa % 16 == 8 && !Helper.isVampire(player)) {
            player.func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), 20, 1));
        }
        if (stack.func_77973_b() == ModItems.VAMPIRE_CLOTHING_CROWN.get() && stack.func_82837_s() && "10000000".equals(stack.func_200301_q().getString())) {
            UtilLib.spawnParticlesAroundEntity((LivingEntity)player, (IParticleData)ParticleTypes.field_197629_v, 0.5, 4);
            if (player.field_70173_aa % 16 == 4) {
                player.func_195064_c(new EffectInstance(Effects.field_188424_y, 30, 0));
                player.func_195064_c(new EffectInstance(Effects.field_204839_B, 100, 2));
            }
        }
    }
}

