/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampirismItemWeapon
extends SwordItem {
    private final float attackDamage;
    private final float attackSpeed;
    private String translation_key;
    private String descriptionId;

    public VampirismItemWeapon(IItemTier material, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(material, attackDamageIn, attackSpeedIn, builder);
        this.attackDamage = attackDamageIn;
        this.attackSpeed = attackSpeedIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent("ModDamage: " + this.getAttackDamage(stack)).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("ModSpeed: " + this.getAttackSpeed(stack)).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185296_A && this instanceof IItemWithTier && ((IItemWithTier)((Object)this)).getVampirismTier() == IItemWithTier.TIER.ULTIMATE) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.attackDamage;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected String func_195935_o() {
        if (this.descriptionId == null) {
            this.descriptionId = super.func_195935_o().replaceAll("_normal|_enhanced|_ultimate", "");
        }
        return this.descriptionId;
    }
}

