/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public abstract class VampirismCrossbowItem
extends CrossbowItem
implements IFactionLevelItem<IHunterPlayer>,
IVampirismCrossbow {
    protected final ItemTier itemTier;
    protected final float arrowVelocity;
    protected final int chargeTime;

    public VampirismCrossbowItem(Item.Properties properties, float arrowVelocity, int chargeTime, ItemTier itemTier) {
        super(properties);
        this.arrowVelocity = arrowVelocity;
        this.chargeTime = chargeTime;
        this.itemTier = itemTier;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World level, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, level, tooltips, flag);
        this.addFactionToolTips(stack, level, tooltips, flag, VampirismMod.proxy.getClientPlayer());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.field_222192_G || this.getCompatibleEnchantments().contains(enchantment);
    }

    protected Collection<Enchantment> getCompatibleEnchantments() {
        return Arrays.asList(Enchantments.field_185312_x, Enchantments.field_185310_v, Enchantments.field_185309_u);
    }

    public boolean func_82789_a(@Nonnull ItemStack crossbow, ItemStack repairItem) {
        return Tags.Items.STRING.func_230235_a_((Object)repairItem.func_77973_b()) || super.func_82789_a(crossbow, repairItem);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.itemTier.func_200927_e();
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public IPlayableFaction<IHunterPlayer> getUsingFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @Nonnull
    public Predicate<ItemStack> func_220006_d() {
        return stack -> false;
    }

    public int func_77626_a(@Nonnull ItemStack crossbow) {
        return this.getChargeDurationMod(crossbow) + 3;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World p_77659_1_, PlayerEntity p_77659_2_, @Nonnull Hand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        if (VampirismCrossbowItem.func_220012_d((ItemStack)itemstack)) {
            this.performShootingMod(p_77659_1_, (LivingEntity)p_77659_2_, p_77659_3_, itemstack, this.getShootingPowerMod(itemstack), 1.0f);
            this.setUncharged(p_77659_2_, itemstack);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!p_77659_2_.func_213356_f(itemstack).func_190926_b()) {
            if (!VampirismCrossbowItem.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                p_77659_2_.func_184598_c(p_77659_3_);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @Override
    public boolean performShootingMod(World level, LivingEntity shooter, Hand hand, ItemStack stack, float speed, float angle) {
        List list = VampirismCrossbowItem.func_220018_j((ItemStack)stack);
        float[] afloat = VampirismCrossbowItem.func_220028_a((Random)shooter.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = (ItemStack)list.get(i);
            boolean bl = flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            this.shootProjectileMod(level, shooter, hand, stack, itemstack, afloat[i], flag, speed, angle, 0.0f);
            break;
        }
        VampirismCrossbowItem.func_220015_a((World)level, (LivingEntity)shooter, (ItemStack)stack);
        return list.isEmpty();
    }

    protected void shootProjectileMod(World p_220016_0_, LivingEntity p_220016_1_, Hand p_220016_2_, ItemStack p_220016_3_, ItemStack p_220016_4_, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (!p_220016_0_.field_72995_K) {
            AbstractArrowEntity projectileentity = this.modifyArrow(p_220016_3_, VampirismCrossbowItem.func_220024_a((World)p_220016_0_, (LivingEntity)p_220016_1_, (ItemStack)p_220016_3_, (ItemStack)p_220016_4_));
            if (p_220016_6_ || p_220016_9_ != 0.0f) {
                projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
            if (p_220016_1_ instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)p_220016_1_;
                icrossbowuser.func_230284_a_(icrossbowuser.func_70638_az(), p_220016_3_, (ProjectileEntity)projectileentity, p_220016_9_);
            } else {
                Vector3d vector3d1 = p_220016_1_.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), p_220016_9_, true);
                Vector3d vector3d = p_220016_1_.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vector3d);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), p_220016_7_, p_220016_8_);
            }
            p_220016_3_.func_222118_a(1, p_220016_1_, p_220017_1_ -> p_220017_1_.func_213334_d(p_220016_2_));
            if (this.isInfinit(p_220016_3_)) {
                projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
            p_220016_0_.func_217376_c((Entity)projectileentity);
            p_220016_0_.func_184148_a((PlayerEntity)null, p_220016_1_.func_226277_ct_(), p_220016_1_.func_226278_cu_(), p_220016_1_.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, p_220016_5_);
        }
    }

    protected AbstractArrowEntity modifyArrow(ItemStack stack, AbstractArrowEntity arrowEntity) {
        int k;
        int j;
        if (this.ignoreHurtTimer(stack) && arrowEntity instanceof IEntityCrossbowArrow) {
            ((IEntityCrossbowArrow)arrowEntity).setIgnoreHurtTimer();
        }
        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)j * 0.2 + 0.2);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
            arrowEntity.func_70240_a(k);
        }
        return arrowEntity;
    }

    protected boolean ignoreHurtTimer(ItemStack crossbow) {
        return false;
    }

    public float getShootingPowerMod(ItemStack crossbow) {
        return 3.15f * this.arrowVelocity;
    }

    public void func_77615_a(@Nonnull ItemStack p_77615_1_, @Nonnull World p_77615_2_, @Nonnull LivingEntity p_77615_3_, int p_77615_4_) {
        int i = this.func_77626_a(p_77615_1_) - p_77615_4_;
        float f = this.getPowerForTimeMod(i, p_77615_1_);
        if (f >= 1.0f && !VampirismCrossbowItem.func_220012_d((ItemStack)p_77615_1_) && this.tryLoadProjectilesMod(p_77615_3_, p_77615_1_)) {
            VampirismCrossbowItem.func_220011_a((ItemStack)p_77615_1_, (boolean)true);
            SoundCategory soundcategory = p_77615_3_ instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            p_77615_2_.func_184148_a(null, p_77615_3_.func_226277_ct_(), p_77615_3_.func_226278_cu_(), p_77615_3_.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getPowerForTimeMod(int p_220031_0_, ItemStack p_220031_1_) {
        float f = (float)p_220031_0_ / (float)this.getChargeDurationMod(p_220031_1_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getChargeDurationMod(ItemStack crossbow) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)crossbow);
        return i == 0 ? this.chargeTime : this.chargeTime - 2 * i;
    }

    protected void setUncharged(PlayerEntity player, ItemStack stack) {
        int frugal = this.isFrugal(stack);
        if (frugal > 0 && field_77697_d.nextInt(Math.max(2, 4 - frugal)) == 0) {
            return;
        }
        VampirismCrossbowItem.func_220011_a((ItemStack)stack, (boolean)false);
    }

    protected int isFrugal(ItemStack crossbow) {
        return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.CROSSBOWFRUGALITY.get()), (ItemStack)crossbow);
    }

    protected boolean isInfinit(ItemStack crossbow) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)crossbow) > 0;
    }

    protected boolean canBeInfinit(ItemStack crossbow) {
        return true;
    }

    protected boolean tryLoadProjectilesMod(LivingEntity entity, ItemStack crossbow) {
        boolean flag = entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d;
        ItemStack projectile = entity.func_213356_f(crossbow);
        if (projectile.func_190926_b() && flag) {
            projectile = new ItemStack((IItemProvider)ModItems.CROSSBOW_ARROW_NORMAL.get());
        }
        if (this.canBeInfinit(crossbow) && this.isInfinit(crossbow) && projectile.func_77973_b() instanceof IVampirismCrossbowArrow && ((IVampirismCrossbowArrow)projectile.func_77973_b()).isCanBeInfinite()) {
            projectile = projectile.func_77946_l();
        }
        return this.loadProjectileMod(entity, crossbow, projectile, false, flag);
    }

    protected boolean loadProjectileMod(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.func_77979_a(1);
            if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        if (itemstack.func_77973_b() instanceof IArrowContainer) {
            for (ItemStack arrow : ((IArrowContainer)itemstack.func_77973_b()).getArrows(itemstack)) {
                VampirismCrossbowItem.func_220029_b((ItemStack)p_220023_1_, (ItemStack)arrow);
            }
        } else {
            VampirismCrossbowItem.func_220029_b((ItemStack)p_220023_1_, (ItemStack)itemstack);
        }
        return true;
    }
}

