/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.oil;

import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.items.oil.Oil;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ApplicableOil
extends Oil
implements IApplicableOil {
    protected final int maxDuration;

    public ApplicableOil(int color, int maxDuration) {
        super(color);
        this.maxDuration = maxDuration;
    }

    @Override
    public int getDuration(ItemStack stack) {
        return OilUtils.getAppliedOilStatus(stack).filter(p -> p.getLeft() == this).map(Pair::getRight).orElse(0);
    }

    @Override
    public boolean reduceDuration(ItemStack stack, IApplicableOil oil, int amount) {
        return OilUtils.reduceAppliedOilDuration(stack, oil, amount);
    }

    @Override
    public int getMaxDuration(ItemStack stack) {
        return this.maxDuration;
    }

    @Override
    public Optional<ITextComponent> getToolTipLine(ItemStack stack, IApplicableOil oil, int duration, ITooltipFlag flag) {
        IFormattableTextComponent component = new TranslationTextComponent(String.format("oil.%s.%s", this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a())).func_240699_a_(TextFormatting.LIGHT_PURPLE);
        if (oil.hasDuration()) {
            TextFormatting status;
            int maxDuration = oil.getMaxDuration(stack);
            float perc = (float)duration / (float)maxDuration;
            TextFormatting textFormatting = (double)perc > 0.5 ? TextFormatting.GREEN : (status = (double)perc > 0.25 ? TextFormatting.GOLD : TextFormatting.RED);
            if (flag.func_194127_a()) {
                component.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("%s/%s", new Object[]{duration, maxDuration}).func_240699_a_(status));
            } else {
                component.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("Status").func_240699_a_(status));
            }
        }
        return Optional.of(component);
    }
}

