/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.oil;

import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EffectWeaponOil
extends WeaponOil {
    @Nonnull
    private final Effect effect;
    private final Supplier<Integer> effectDuration;

    public EffectWeaponOil(@Nonnull Effect effect, @Nonnull Supplier<Integer> effectDuration, int maxDuration) {
        super(effect.getEffect().func_76401_j(), maxDuration);
        this.effect = Objects.requireNonNull(effect);
        this.effectDuration = Objects.requireNonNull(effectDuration);
    }

    public EffectWeaponOil(@Nonnull Effect effect, int effectDuration, int maxDuration) {
        this(effect, () -> effectDuration, maxDuration);
    }

    @Nonnull
    public Effect getEffect() {
        return this.effect;
    }

    @Nonnull
    public EffectInstance getEffectInstance() {
        return new EffectInstance(this.effect, this.effectDuration.get().intValue());
    }

    @Override
    public float onHit(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        target.func_195064_c(this.getEffectInstance());
        return 0.0f;
    }

    @Override
    public void getDescription(ItemStack stack, List<ITextComponent> tooltips) {
        tooltips.add(StringTextComponent.field_240750_d_);
        tooltips.add((ITextComponent)new TranslationTextComponent("text.vampirism.oil.effect_on_hit").func_240699_a_(TextFormatting.DARK_PURPLE));
        tooltips.add(this.getEffectDescriptionWithDash(this.getEffectInstance()));
    }

    private ITextComponent getEffectDescriptionWithDash(EffectInstance instance) {
        TranslationTextComponent component = new TranslationTextComponent(instance.func_76453_d());
        if (instance.func_76458_c() > 0) {
            component = new TranslationTextComponent("potion.withAmplifier", new Object[]{component, new TranslationTextComponent("potion.potency." + instance.func_76458_c())});
        }
        if (instance.func_76459_b() > 20) {
            component = new TranslationTextComponent("potion.withDuration", new Object[]{component, EffectUtils.func_188410_a((EffectInstance)instance, (float)1.0f)});
        }
        return new StringTextComponent("- ").func_230529_a_((ITextComponent)component).func_240699_a_(this.effect.func_220303_e().func_220306_a());
    }
}

