/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.mixin;

import de.teamlapen.vampirism.effects.VampirismPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionBrewing.class})
public class MixinPotionBrewing {
    @Inject(method={"hasContainerMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleItemConversionHunterPotion(ItemStack input, ItemStack reagent, CallbackInfoReturnable<Boolean> cir) {
        if (MixinPotionBrewing.shouldBlockBrewing_vampirism(input, reagent)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleDoReactionHunterPotion(ItemStack reagent, ItemStack potionIn, CallbackInfoReturnable<ItemStack> cir) {
        if (MixinPotionBrewing.shouldBlockBrewing_vampirism(potionIn, reagent)) {
            cir.setReturnValue((Object)potionIn);
            cir.cancel();
        }
    }

    private static boolean shouldBlockBrewing_vampirism(ItemStack input, ItemStack reagent) {
        return VampirismPotion.isHunterPotion(input, true).map(Potion::func_185170_a).flatMap(effects -> effects.stream().map(EffectInstance::func_188419_a).filter(Effect::func_188408_i).findAny()).isPresent();
    }
}

