/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TaskRecipeCategory
implements IRecipeCategory<Task> {
    private final IDrawable background;
    private final IDrawable icon;

    public TaskRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/slot.png"), 0, 0, 18, 18).setTextureSize(18, 18).addPadding(14, 90, 75, 75).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.VAMPIRE_FANG.get()));
    }

    public void draw(Task task, MatrixStack stack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int x = 4;
        int y = 40;
        minecraft.field_71466_p.func_243248_b(stack, task.getTranslation(), 1.0f, 1.0f, Color.gray.getRGB());
        IPlayableFaction<?> f = task.getFaction();
        TranslationTextComponent taskmasterComponent = f == null || f.getVillageData().getTaskMasterEntity() == null ? new TranslationTextComponent("text.vampirism.faction_representative") : new TranslationTextComponent(f.getVillageData().getTaskMasterEntity().func_210760_d());
        TranslationTextComponent text = new TranslationTextComponent("text.vampirism.task.reward_obtain", new Object[]{taskmasterComponent});
        y += UtilLib.renderMultiLine(minecraft.field_71466_p, stack, (ITextComponent)text, 160, x, y, Color.gray.getRGB());
        IFormattableTextComponent prerequisites = new TranslationTextComponent("text.vampirism.task.prerequisites").func_240702_b_(":\n");
        TaskUnlocker[] unlockers = task.getUnlocker();
        if (unlockers.length > 0) {
            StringTextComponent newLine = new StringTextComponent("\n");
            for (TaskUnlocker u : unlockers) {
                prerequisites.func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_230529_a_(u.getDescription()).func_230529_a_((ITextComponent)newLine);
            }
        } else {
            prerequisites.func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.task.prerequisites.none"));
        }
        y += UtilLib.renderMultiLine(minecraft.field_71466_p, stack, (ITextComponent)prerequisites, 160, x, y, Color.gray.getRGB());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends Task> getRecipeClass() {
        return Task.class;
    }

    public String getTitle() {
        return UtilLib.translate("text.vampirism.task.reward", new Object[0]);
    }

    public ResourceLocation getUid() {
        return VampirismJEIPlugin.TASK_RECIPE_UID;
    }

    public void setIngredients(Task recipe, IIngredients ingredients) {
        TaskReward reward = recipe.getReward();
        if (reward instanceof ItemReward) {
            ingredients.setOutputs(VanillaTypes.ITEM, ((ItemReward)reward).getAllPossibleRewards());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, Task recipe, IIngredients ingredients) {
        int craftOutputSlot = 0;
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(craftOutputSlot, false, 75, 14);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStackGroup.set(craftOutputSlot, outputs.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }
}

