/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WeaponTableRecipeCategory
implements IRecipeCategory<IWeaponTableRecipe> {
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/weapon_table_clean.png");
    private static final ItemStack lavaStack = new ItemStack((IItemProvider)Items.field_151129_at);
    private final String localizedName = UtilLib.translate(((WeaponTableBlock)ModBlocks.WEAPON_TABLE.get()).func_149739_a(), new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    WeaponTableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(location, 32, 14, 134, 77).addPadding(0, 33, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.WEAPON_TABLE.get()));
    }

    public void draw(IWeaponTableRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        ISkill[] requiredSkills;
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (recipe.getRequiredLavaUnits() > 0) {
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
            minecraft.func_175599_af().func_175042_a(lavaStack, 83, 13);
            RenderSystem.popMatrix();
        }
        if (recipe.getRequiredLevel() > 1) {
            TranslationTextComponent level = new TranslationTextComponent("gui.vampirism.hunter_weapon_table.level", new Object[]{recipe.getRequiredLevel()});
            minecraft.field_71466_p.func_243248_b(stack, (ITextComponent)level, (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9 + 2;
        }
        if ((requiredSkills = recipe.getRequiredSkills()).length > 0) {
            TranslationTextComponent skillText = new TranslationTextComponent("gui.vampirism.skill_required", new Object[]{" "});
            for (ISkill skill : recipe.getRequiredSkills()) {
                skillText.func_230529_a_(skill.getName()).func_240702_b_(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.field_71466_p, stack, (ITextComponent)skillText, 132, x, y, Color.gray.getRGB());
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends IWeaponTableRecipe> getRecipeClass() {
        return IWeaponTableRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.WEAPON_TABLE_RECIPE_ID;
    }

    public void setIngredients(IWeaponTableRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, IWeaponTableRecipe recipe, IIngredients ingredients) {
        int craftOutputSlot = 0;
        IGuiItemStackGroup guiItemStackGroup = iRecipeLayout.getItemStacks();
        guiItemStackGroup.init(craftOutputSlot, false, 111, 31);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                guiItemStackGroup.init(1 + x + y * 4, true, 1 + x * 19, 1 + y * 19);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipe instanceof ShapedWeaponTableRecipe) {
            ShapedWeaponTableRecipe wrapper = (ShapedWeaponTableRecipe)recipe;
            this.setInputs(guiItemStackGroup, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else if (recipe instanceof ShapelessWeaponTableRecipe) {
            this.setInputs(guiItemStackGroup, inputs);
            iRecipeLayout.setShapeless();
        }
        guiItemStackGroup.set(craftOutputSlot, (List)outputs.get(0));
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 4 ? i * 4 + 1 : (height == 3 ? i * 4 + 1 : (height == 2 ? i * 4 + 1 : 0));
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                }
            }
        } else if (width == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                    if (i > 8) {
                        ++index;
                    }
                }
            }
        } else {
            index = height == 2 ? i + 4 : i;
        }
        return index;
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs) {
        int width;
        int height;
        if (inputs.size() > 4) {
            height = 4;
            width = 4;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            ingredientGroup.set(1 + index, recipeItem);
        }
    }
}

