/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CActionBindingPacket
implements IMessage {
    public final int actionBindingId;
    public final IAction action;

    static void encode(CActionBindingPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.actionBindingId);
        buf.func_180714_a(msg.action.getRegistryName().toString());
    }

    static CActionBindingPacket decode(PacketBuffer buf) {
        return new CActionBindingPacket(buf.func_150792_a(), (IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE))));
    }

    public static void handle(CActionBindingPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(factionPlayerHandler -> factionPlayerHandler.setBoundAction(msg.actionBindingId, msg.action, false, false)));
        ctx.setPacketHandled(true);
    }

    public CActionBindingPacket(int actionBindingId, IAction action) {
        this.actionBindingId = actionBindingId;
        this.action = action;
    }
}

