/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CDeleteRefinementPacket
implements IMessage {
    private final IRefinementItem.AccessorySlotType slot;

    static void encode(CDeleteRefinementPacket msg, PacketBuffer buf) {
        buf.func_179249_a((Enum)msg.slot);
    }

    static CDeleteRefinementPacket decode(PacketBuffer buf) {
        return new CDeleteRefinementPacket((IRefinementItem.AccessorySlotType)buf.func_179257_a(IRefinementItem.AccessorySlotType.class));
    }

    static void handle(CDeleteRefinementPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            factionPlayerOpt.ifPresent(fp -> fp.getSkillHandler().removeRefinementItem(msg.slot));
        });
        ctx.setPacketHandled(true);
    }

    public CDeleteRefinementPacket(IRefinementItem.AccessorySlotType slot) {
        this.slot = slot;
    }
}

