/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSelectMinionTaskPacket
implements IMessage {
    public static final ResourceLocation RECALL = new ResourceLocation("vampirism", "recall");
    public static final ResourceLocation RESPAWN = new ResourceLocation("vampirism", "respawn");
    private static final Logger LOGGER = LogManager.getLogger();
    public final int minionID;
    public final ResourceLocation taskID;

    public static void handle(CSelectMinionTaskPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(fp -> {
            PlayerMinionController controller = MinionWorldData.getData(player.field_71133_b).getOrCreateController((FactionPlayerHandler)fp);
            if (RECALL.equals((Object)msg.taskID)) {
                if (msg.minionID < 0) {
                    Collection<Integer> ids = controller.recallMinions(false);
                    for (Integer id : ids) {
                        controller.createMinionEntityAtPlayer(id, (PlayerEntity)player);
                    }
                    CSelectMinionTaskPacket.printRecoveringMinions(player, controller.getRecoveringMinionNames());
                } else if (controller.recallMinion(msg.minionID)) {
                    controller.createMinionEntityAtPlayer(msg.minionID, (PlayerEntity)player);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion_is_still_recovering", new Object[]{controller.contactMinionData(msg.minionID, MinionData::getFormattedName).orElse((IFormattableTextComponent)new StringTextComponent("1"))}), true);
                }
            } else if (RESPAWN.equals((Object)msg.taskID)) {
                Collection<Integer> ids = controller.getUnclaimedMinions();
                for (Integer id : ids) {
                    controller.createMinionEntityAtPlayer(id, (PlayerEntity)player);
                }
                CSelectMinionTaskPacket.printRecoveringMinions(player, controller.getRecoveringMinionNames());
            } else {
                IMinionTask task = (IMinionTask)ModRegistries.MINION_TASKS.getValue(msg.taskID);
                if (task == null) {
                    LOGGER.error("Cannot find action to activate {}", (Object)msg.taskID);
                } else if (msg.minionID < -1) {
                    LOGGER.error("Illegal minion id {}", (Object)msg.minionID);
                } else {
                    controller.activateTask(msg.minionID, task);
                }
            }
        }));
        ctx.setPacketHandled(true);
    }

    public static void printRecoveringMinions(ServerPlayerEntity player, List<IFormattableTextComponent> recoveringMinions) {
        if (recoveringMinions.size() == 1) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion_is_still_recovering", new Object[]{recoveringMinions.get(0)}), true);
        } else if (recoveringMinions.size() > 1) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.n_minions_are_still_recovering", new Object[]{recoveringMinions.size()}), true);
        }
    }

    static void encode(CSelectMinionTaskPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.minionID);
        buf.func_192572_a(msg.taskID);
    }

    static CSelectMinionTaskPacket decode(PacketBuffer buf) {
        return new CSelectMinionTaskPacket(buf.func_150792_a(), buf.func_192575_l());
    }

    public CSelectMinionTaskPacket(int minionID, ResourceLocation taskID) {
        assert (minionID >= -1);
        this.minionID = minionID;
        this.taskID = taskID;
    }
}

