/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.HunterBasicContainer;
import de.teamlapen.vampirism.inventory.container.HunterTrainerContainer;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.SRequestMinionSelectPacket;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CSimpleInputEvent
implements IMessage {
    private final Type type;

    static void encode(CSimpleInputEvent msg, PacketBuffer buf) {
        buf.func_179249_a((Enum)msg.type);
    }

    static CSimpleInputEvent decode(PacketBuffer buf) {
        Type t = (Type)buf.func_179257_a(Type.class);
        return new CSimpleInputEvent(t);
    }

    static void handle(CSimpleInputEvent msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            switch (msg.type) {
                case FINISH_SUCK_BLOOD: {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vampire -> vampire.endFeeding(true));
                    break;
                }
                case RESET_SKILLS: {
                    InventoryHelper.removeItemFromInventory((IInventory)player.field_71071_by, new ItemStack((IItemProvider)ModItems.OBLIVION_POTION.get()));
                    factionPlayerOpt.ifPresent(OblivionItem::applyEffect);
                    break;
                }
                case REVERT_BACK: {
                    FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(handler -> handler.leaveFaction(!player.field_71133_b.func_71199_h()));
                    break;
                }
                case TOGGLE_VAMPIRE_VISION: {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::switchVision);
                    break;
                }
                case TRAINER_LEVELUP: {
                    if (!(player.field_71070_bA instanceof HunterTrainerContainer)) break;
                    ((HunterTrainerContainer)player.field_71070_bA).onLevelupClicked();
                    break;
                }
                case BASIC_HUNTER_LEVELUP: {
                    if (!(player.field_71070_bA instanceof HunterBasicContainer)) break;
                    ((HunterBasicContainer)player.field_71070_bA).onLevelUpClicked();
                    break;
                }
                case SHOW_MINION_CALL_SELECTION: {
                    SRequestMinionSelectPacket.createRequestForPlayer(player, SRequestMinionSelectPacket.Action.CALL).ifPresent(x -> VampirismMod.dispatcher.sendTo((IMessage)x, player));
                    break;
                }
                case VAMPIRISM_MENU: {
                    factionPlayerOpt.ifPresent(fPlayer -> fPlayer.getTaskManager().openVampirismMenu());
                    break;
                }
                case RESURRECT: {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::tryResurrect);
                    break;
                }
                case GIVE_UP: {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::giveUpDBNO);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public CSimpleInputEvent(Type type) {
        this.type = type;
    }

    public static enum Type {
        FINISH_SUCK_BLOOD,
        RESET_SKILLS,
        REVERT_BACK,
        TOGGLE_VAMPIRE_VISION,
        TRAINER_LEVELUP,
        BASIC_HUNTER_LEVELUP,
        SHOW_MINION_CALL_SELECTION,
        VAMPIRISM_MENU,
        RESURRECT,
        GIVE_UP;

    }
}

