/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Either;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CStartFeedingPacket
implements IMessage {
    private final Either<Integer, BlockPos> target;

    static void encode(CStartFeedingPacket msg, PacketBuffer buffer) {
        msg.target.ifLeft(entityID -> {
            buffer.writeBoolean(false);
            buffer.func_150787_b(entityID.intValue());
        });
        msg.target.ifRight(targetPos -> {
            buffer.writeBoolean(true);
            buffer.func_179255_a(targetPos);
        });
    }

    static CStartFeedingPacket decode(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            return new CStartFeedingPacket(buffer.func_179259_c());
        }
        return new CStartFeedingPacket(buffer.func_150792_a());
    }

    static void handle(CStartFeedingPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vampire -> {
            msg.target.ifLeft(vampire::biteEntity);
            msg.target.ifRight(vampire::biteBlock);
        }));
        ctx.setPacketHandled(true);
    }

    public CStartFeedingPacket(int entityID) {
        this.target = Either.left((Object)entityID);
    }

    public CStartFeedingPacket(BlockPos targetPosition) {
        this.target = Either.right((Object)targetPosition);
    }
}

