/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Either;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CToggleActionPacket
implements IMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation actionId;
    @Nullable
    private final Either<Integer, BlockPos> target;

    public static CToggleActionPacket createFromRaytrace(ResourceLocation action, RayTraceResult traceResult) {
        Either target = null;
        if (traceResult != null) {
            if (traceResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                target = Either.left((Object)((EntityRayTraceResult)traceResult).func_216348_a().func_145782_y());
            } else if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                target = Either.right((Object)((BlockRayTraceResult)traceResult).func_216350_a());
            }
        }
        return new CToggleActionPacket(action, target);
    }

    static void encode(CToggleActionPacket msg, PacketBuffer buf) {
        buf.func_192572_a(msg.actionId);
        if (msg.target != null) {
            buf.writeBoolean(true);
            msg.target.ifLeft(i -> {
                buf.writeBoolean(true);
                buf.func_150787_b(i.intValue());
            });
            msg.target.ifRight(p -> {
                buf.writeBoolean(false);
                buf.func_179255_a(p);
            });
        } else {
            buf.writeBoolean(false);
        }
    }

    static CToggleActionPacket decode(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        Either target = null;
        if (buf.readBoolean()) {
            target = buf.readBoolean() ? Either.left((Object)buf.func_150792_a()) : Either.right((Object)buf.func_179259_c());
        }
        return new CToggleActionPacket(id, target);
    }

    static void handle(CToggleActionPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            factionPlayerOpt.ifPresent(factionPlayer -> {
                ActionHandler.ActivationContext context = msg.target != null ? (IAction.ActivationContext)msg.target.map(entityId -> {
                    Entity e = player.func_130014_f_().func_73045_a(entityId.intValue());
                    if (e == null) {
                        LOGGER.warn("Could not find entity {} the player was looking at when toggling action", entityId);
                    }
                    return new ActionHandler.ActivationContext(e);
                }, ActionHandler.ActivationContext::new) : new ActionHandler.ActivationContext();
                IActionHandler actionHandler = factionPlayer.getActionHandler();
                IAction action = (IAction)ModRegistries.ACTIONS.getValue(msg.actionId);
                if (action != null) {
                    IAction.PERM r = actionHandler.toggleAction(action, context);
                    switch (r) {
                        case NOT_UNLOCKED: {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.not_unlocked"), true);
                            break;
                        }
                        case DISABLED: {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.deactivated_by_serveradmin"), false);
                            break;
                        }
                        case COOLDOWN: {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.cooldown_not_over"), true);
                            break;
                        }
                        case DISALLOWED: {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.disallowed"), true);
                            break;
                        }
                        case PERMISSION_DISALLOWED: {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.permission_disallowed"), false);
                            break;
                        }
                    }
                } else {
                    LOGGER.error("Failed to find action with id {}", (Object)msg.actionId);
                }
            });
        });
        ctx.setPacketHandled(true);
    }

    public CToggleActionPacket(ResourceLocation actionId, @Nullable Either<Integer, BlockPos> target) {
        this.actionId = actionId;
        this.target = target;
    }
}

