/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CToggleMinionTaskLock
implements IMessage {
    private final int minionID;

    static void encode(CToggleMinionTaskLock msg, PacketBuffer buf) {
        buf.func_150787_b(msg.minionID);
    }

    static CToggleMinionTaskLock decode(PacketBuffer buf) {
        return new CToggleMinionTaskLock(buf.func_150792_a());
    }

    static void handle(CToggleMinionTaskLock msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((PlayerEntity)ctx.getSender()).ifPresent(fp -> {
            PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().field_71133_b).getOrCreateController((FactionPlayerHandler)fp);
            controller.contactMinionData(msg.minionID, data -> data.setTaskLocked(!data.isTaskLocked()));
            controller.contactMinion(msg.minionID, MinionEntity::onTaskChanged);
        }));
        ctx.setPacketHandled(true);
    }

    public CToggleMinionTaskLock(int minionID) {
        this.minionID = minionID;
    }
}

