/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SBloodValuePacket
implements IMessage {
    private final Map<ResourceLocation, Float>[] values;

    static void encode(SBloodValuePacket msg, PacketBuffer buf) {
        for (Map<ResourceLocation, Float> e : msg.values) {
            buf.func_150787_b(e.size());
            for (Map.Entry<ResourceLocation, Float> f : e.entrySet()) {
                buf.func_192572_a(f.getKey());
                buf.writeFloat(f.getValue().floatValue());
            }
        }
    }

    static SBloodValuePacket decode(PacketBuffer buf) {
        Map[] values = (Map[])Array.newInstance(Map.class, 3);
        for (int i = 0; i < 3; ++i) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int z = buf.func_150792_a();
            for (int u = 0; u < z; ++u) {
                builder.put((Object)buf.func_192575_l(), (Object)Float.valueOf(buf.readFloat()));
            }
            values[i] = builder.build();
        }
        return new SBloodValuePacket(values);
    }

    public static void handle(SBloodValuePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleBloodValuePacket(msg));
        ctx.setPacketHandled(true);
    }

    public SBloodValuePacket(Map<ResourceLocation, Float>[] values) {
        this.values = values;
    }

    public Map<ResourceLocation, Float>[] getValues() {
        return this.values;
    }
}

