/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.network.CSelectMinionTaskPacket;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SRequestMinionSelectPacket
implements IMessage {
    public final List<Pair<Integer, ITextComponent>> minions;
    public final Action action;

    public static Optional<SRequestMinionSelectPacket> createRequestForPlayer(ServerPlayerEntity player, Action action) {
        return FactionPlayerHandler.getOpt((PlayerEntity)player).resolve().flatMap(fp -> {
            PlayerMinionController controller = MinionWorldData.getData(player.field_71133_b).getOrCreateController((FactionPlayerHandler)fp);
            Collection<Integer> ids = controller.getCallableMinions();
            if (ids.size() > 0) {
                ArrayList<Pair<Integer, ITextComponent>> minions = new ArrayList<Pair<Integer, ITextComponent>>(ids.size());
                ids.forEach(id -> controller.contactMinionData((int)id, data -> data.getFormattedName().func_230532_e_()).ifPresent(n -> minions.add(Pair.of((Object)id, (Object)n))));
                return Optional.of(new SRequestMinionSelectPacket(action, minions));
            }
            CSelectMinionTaskPacket.printRecoveringMinions(player, controller.getRecoveringMinionNames());
            return Optional.empty();
        });
    }

    public static void handle(SRequestMinionSelectPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleRequestMinionSelect(msg.action, msg.minions));
        ctx.setPacketHandled(true);
    }

    static void encode(SRequestMinionSelectPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.action.ordinal());
        buf.func_150787_b(msg.minions.size());
        for (Pair<Integer, ITextComponent> minion : msg.minions) {
            buf.func_150787_b(((Integer)minion.getLeft()).intValue());
            buf.func_179256_a((ITextComponent)minion.getRight());
        }
    }

    static SRequestMinionSelectPacket decode(PacketBuffer buf) {
        Action a = Action.values()[buf.func_150792_a()];
        int count = buf.func_150792_a();
        ArrayList<Pair<Integer, ITextComponent>> minions = new ArrayList<Pair<Integer, ITextComponent>>(count);
        for (int i = 0; i < count; ++i) {
            minions.add((Pair<Integer, ITextComponent>)Pair.of((Object)buf.func_150792_a(), (Object)buf.func_179258_d()));
        }
        return new SRequestMinionSelectPacket(a, minions);
    }

    public SRequestMinionSelectPacket(Action action, List<Pair<Integer, ITextComponent>> minions) {
        this.action = action;
        this.minions = minions;
    }

    public static enum Action {
        CALL;

    }
}

