/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.world.MultiBossInfo;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraftforge.fml.network.NetworkEvent;

public class SUpdateMultiBossInfoPacket
implements IMessage {
    private final UUID uniqueId;
    private final SUpdateBossInfoPacket.Operation operation;
    protected List<Color> colors;
    protected Map<Color, Float> entries;
    private ITextComponent name;
    private BossInfo.Overlay overlay;

    static void encode(SUpdateMultiBossInfoPacket msg, PacketBuffer buf) {
        buf.func_179252_a(msg.uniqueId);
        buf.func_179249_a((Enum)msg.operation);
        switch (msg.operation) {
            case ADD: {
                buf.func_179256_a(msg.name);
                buf.func_150787_b(msg.colors.size());
                msg.colors.forEach(color -> buf.func_150787_b(color.getRGB()));
                buf.func_179249_a((Enum)msg.overlay);
            }
            case UPDATE_PCT: {
                buf.func_150787_b(msg.entries.size());
                for (Map.Entry<Color, Float> value : msg.entries.entrySet()) {
                    buf.func_150787_b(value.getKey().getRGB());
                    buf.writeFloat(value.getValue().floatValue());
                }
                break;
            }
            case UPDATE_NAME: {
                buf.func_179256_a(msg.name);
                break;
            }
            case UPDATE_STYLE: {
                buf.func_179249_a((Enum)msg.overlay);
            }
        }
    }

    static SUpdateMultiBossInfoPacket decode(PacketBuffer buf) {
        UUID uuid = buf.func_179253_g();
        SUpdateBossInfoPacket.Operation operation = (SUpdateBossInfoPacket.Operation)buf.func_179257_a(SUpdateBossInfoPacket.Operation.class);
        SUpdateMultiBossInfoPacket packet = new SUpdateMultiBossInfoPacket(operation, uuid);
        switch (operation) {
            case ADD: {
                packet.name = buf.func_179258_d();
                int size = buf.func_150792_a();
                LinkedList<Color> colors = new LinkedList<Color>();
                for (int i = 0; i < size; ++i) {
                    colors.add(new Color(buf.func_150792_a(), true));
                }
                packet.colors = colors;
                packet.overlay = (BossInfo.Overlay)buf.func_179257_a(BossInfo.Overlay.class);
            }
            case UPDATE_PCT: {
                LinkedHashMap<Color, Float> entries = new LinkedHashMap<Color, Float>();
                int size2 = buf.func_150792_a();
                for (int i = 0; i < size2; ++i) {
                    Color color = new Color(buf.func_150792_a(), true);
                    float perc = buf.readFloat();
                    entries.put(color, Float.valueOf(perc));
                }
                packet.entries = entries;
                break;
            }
            case UPDATE_NAME: {
                packet.name = buf.func_179258_d();
                break;
            }
            case UPDATE_STYLE: {
                packet.overlay = (BossInfo.Overlay)buf.func_179257_a(BossInfo.Overlay.class);
            }
        }
        return packet;
    }

    public static void handle(SUpdateMultiBossInfoPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleUpdateMultiBossInfoPacket(msg));
        ctx.setPacketHandled(true);
    }

    public SUpdateMultiBossInfoPacket(SUpdateBossInfoPacket.Operation operation, MultiBossInfo data) {
        this.uniqueId = data.getUniqueId();
        this.operation = operation;
        this.name = data.getName();
        this.colors = data.getColors();
        this.entries = data.getEntries();
        this.overlay = data.getOverlay();
    }

    private SUpdateMultiBossInfoPacket(SUpdateBossInfoPacket.Operation operation, UUID uuid) {
        this.uniqueId = uuid;
        this.operation = operation;
        this.entries = new LinkedHashMap<Color, Float>();
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public Map<Color, Float> getEntries() {
        return this.entries;
    }

    public ITextComponent getName() {
        return this.name;
    }

    public SUpdateBossInfoPacket.Operation getOperation() {
        return this.operation;
    }

    public BossInfo.Overlay getOverlay() {
        return this.overlay;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }
}

