/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.refinements;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Refinement
extends ForgeRegistryEntry<IRefinement>
implements IRefinement {
    private final Attribute attribute;
    private final BiFunction<UUID, Double, AttributeModifier> modifier;
    private final UUID uuid;
    private final double baseValue;
    private boolean detrimental = false;
    private IFormattableTextComponent description;

    public Refinement(Attribute attribute, UUID uuid, double baseValue, BiFunction<UUID, Double, AttributeModifier> modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.uuid = uuid;
        this.baseValue = baseValue;
    }

    public Refinement() {
        this.attribute = null;
        this.modifier = null;
        this.baseValue = 0.0;
        this.uuid = null;
    }

    @Override
    public AttributeModifier createAttributeModifier(UUID uuid, double value) {
        return this.modifier == null ? null : this.modifier.apply(uuid, value);
    }

    @Override
    @Nullable
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    @Nonnull
    public ITextComponent getDescription() {
        if (this.description == null) {
            this.description = new TranslationTextComponent("refinement." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a() + ".desc");
            if (this.detrimental) {
                this.description.func_240699_a_(TextFormatting.RED);
            }
        }
        return this.description;
    }

    @Override
    public double getModifierValue() {
        return this.baseValue;
    }

    @Override
    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public Refinement setDetrimental() {
        this.detrimental = true;
        return this;
    }
}

